/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.enums;

import com.seibel.distanthorizons.core.util.math.Vec3i;

public enum EDhDirection {
    DOWN("down", AxisDirection.NEGATIVE, Axis.Y, new Vec3i(0, -1, 0), -1),
    UP("up", AxisDirection.POSITIVE, Axis.Y, new Vec3i(0, 1, 0), -1),
    NORTH("north", AxisDirection.NEGATIVE, Axis.Z, new Vec3i(0, 0, -1), 0),
    SOUTH("south", AxisDirection.POSITIVE, Axis.Z, new Vec3i(0, 0, 1), 1),
    WEST("west", AxisDirection.NEGATIVE, Axis.X, new Vec3i(-1, 0, 0), 2),
    EAST("east", AxisDirection.POSITIVE, Axis.X, new Vec3i(1, 0, 0), 3);

    public static final EDhDirection[] ALL;
    public static final EDhDirection[] CARDINAL_COMPASS;
    public final String name;
    public final Axis axis;
    public final AxisDirection axisDirection;
    public final Vec3i normal;
    public final int compassIndex;

    private EDhDirection(String name, AxisDirection axisDirection, Axis axis, Vec3i normal, int compassIndex) {
        this.name = name;
        this.axis = axis;
        this.axisDirection = axisDirection;
        this.normal = normal;
        this.compassIndex = compassIndex;
    }

    public EDhDirection opposite() {
        switch (this.ordinal()) {
            case 1: {
                return DOWN;
            }
            case 0: {
                return UP;
            }
            case 2: {
                return SOUTH;
            }
            case 3: {
                return NORTH;
            }
            case 5: {
                return WEST;
            }
            case 4: {
                return EAST;
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return this.name;
    }

    static {
        ALL = new EDhDirection[]{UP, DOWN, WEST, EAST, NORTH, SOUTH};
        CARDINAL_COMPASS = new EDhDirection[]{EAST, WEST, SOUTH, NORTH};
    }

    public static enum Axis {
        X("x"),
        Y("y"),
        Z("z");

        public final String name;

        private Axis(String name) {
            this.name = name;
        }

        public boolean isVertical() {
            return this == Y;
        }

        public boolean isHorizontal() {
            return this == X || this == Z;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum AxisDirection {
        POSITIVE(1, "Towards positive"),
        NEGATIVE(-1, "Towards negative");

        public final int step;
        public final String name;

        private AxisDirection(int newStep, String newName) {
            this.step = newStep;
            this.name = newName;
        }

        public AxisDirection opposite() {
            return this == POSITIVE ? NEGATIVE : POSITIVE;
        }

        public String toString() {
            return this.name;
        }
    }
}

