/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.network.packet.s2c;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import org.vivecraft.common.network.packet.PayloadIdentifier;
import org.vivecraft.common.network.packet.s2c.VivecraftPayloadS2C;

public record ServerVrChangesS2CPacket(Map<String, String> changes) implements VivecraftPayloadS2C
{
    @Override
    public PayloadIdentifier payloadId() {
        return PayloadIdentifier.SERVER_VR_CHANGES;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeByte(this.payloadId().ordinal());
        for (Map.Entry<String, String> entry : this.changes.entrySet()) {
            buffer.writeUtf(entry.getKey());
            buffer.writeUtf(entry.getValue());
        }
    }

    public static ServerVrChangesS2CPacket read(FriendlyByteBuf buffer) {
        HashMap<String, String> overrides = new HashMap<String, String>();
        while (buffer.readableBytes() > 0) {
            overrides.put(buffer.readUtf(), buffer.readUtf());
        }
        return new ServerVrChangesS2CPacket(overrides);
    }
}

