/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.provider.nullvr;

import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.MethodHolder;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.provider.ControllerTransform;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.provider.DeviceSource;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.provider.VRRenderer;
import org.vivecraft.client_vr.provider.nullvr.BodyPart;
import org.vivecraft.client_vr.provider.nullvr.NullVRHapticScheduler;
import org.vivecraft.client_vr.provider.nullvr.NullVRStereoRenderer;
import org.vivecraft.client_vr.provider.openvr_lwjgl.VRInputAction;
import org.vivecraft.client_vr.render.MirrorNotification;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;

public class NullVR
extends MCVR {
    protected static NullVR OME;
    private boolean vrActive = true;
    protected static final int HEAD_TRACKER = 2;
    private BodyPart currentBodyPart = BodyPart.HEAD;
    private FBTMode fbtMode = FBTMode.ARMS_ONLY;
    private boolean syncBodyparts = true;
    private boolean moveRoom = true;
    private ControllerTransform controllerType = ControllerTransform.NULL;
    private final Vector3f[] deviceOffsets = new Vector3f[10];
    private final Quaternionf[] deviceRotations = new Quaternionf[10];

    public NullVR(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh, VivecraftVRMod.INSTANCE);
        OME = this;
        this.hapticScheduler = new NullVRHapticScheduler();
        this.deviceOffsets[0] = new Vector3f(0.3f, 1.25f, -0.5f);
        this.deviceOffsets[1] = this.deviceOffsets[0].mul(-1.0f, 1.0f, 1.0f, new Vector3f());
        this.deviceOffsets[2] = new Vector3f(0.0f, 1.62f, 0.0f);
        this.deviceOffsets[3] = new Vector3f(0.0f, 0.85f, 0.0f);
        this.deviceOffsets[4] = new Vector3f(0.15f, 0.05f, 0.0f);
        this.deviceOffsets[5] = this.deviceOffsets[4].mul(-1.0f, 1.0f, 1.0f, new Vector3f());
        this.deviceOffsets[6] = new Vector3f(0.3f, 1.25f, -0.1f);
        this.deviceOffsets[7] = this.deviceOffsets[6].mul(-1.0f, 1.0f, 1.0f, new Vector3f());
        this.deviceOffsets[8] = new Vector3f(0.15f, 0.5f, 0.0f);
        this.deviceOffsets[9] = this.deviceOffsets[8].mul(-1.0f, 1.0f, 1.0f, new Vector3f());
        for (int i = 0; i < 10; ++i) {
            this.deviceRotations[i] = new Quaternionf();
        }
    }

    public static NullVR get() {
        return OME;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.initialized = false;
    }

    @Override
    public String getName() {
        return "nullDriver";
    }

    @Override
    public Vector2fc getPlayAreaSize() {
        return new Vector2f(2.0f);
    }

    @Override
    public boolean init() {
        if (!this.initialized) {
            this.mc = Minecraft.getInstance();
            VRSettings.LOGGER.info("Vivecraft: NullDriver. Forcing seated mode.");
            this.headIsTracking = true;
            this.hmdPose.identity();
            this.hmdPose.m31(1.62f);
            this.hmdPoseLeftEye.m30(-this.dh.vrSettings.nullvrIPD * 0.5f);
            this.hmdPoseRightEye.m30(this.dh.vrSettings.nullvrIPD * 0.5f);
            this.populateInputActions();
            this.initialized = true;
            this.initSuccess = true;
        }
        return this.initialized;
    }

    @Override
    public void poll(long frameIndex) {
        if (this.initialized) {
            this.mc.getProfiler().push("updatePose");
            float xSens = this.dh.vrSettings.xSensitivity;
            float xKey = this.dh.vrSettings.keyholeX;
            this.dh.vrSettings.xSensitivity = this.dh.vrSettings.ySensitivity * 1.636f * ((float)this.mc.getWindow().getScreenWidth() / (float)this.mc.getWindow().getScreenHeight());
            this.dh.vrSettings.keyholeX = 1.0f;
            boolean swapHands = this.dh.vrSettings.reverseHands;
            this.controllerPose[0] = this.controllerType.tipR.invert(new Matrix4f());
            this.controllerPose[0].rotate((Quaternionfc)this.deviceRotations[swapHands ? 1 : 0]);
            this.controllerPose[0].setTranslation((Vector3fc)this.deviceOffsets[swapHands ? 1 : 0]);
            this.controllerPose[1] = this.controllerType.tipL.invert(new Matrix4f());
            this.controllerPose[1].rotate((Quaternionfc)this.deviceRotations[swapHands ? 0 : 1]);
            this.controllerPose[1].setTranslation((Vector3fc)this.deviceOffsets[swapHands ? 0 : 1]);
            this.hmdPose.rotation((Quaternionfc)this.deviceRotations[2]);
            this.hmdPose.setTranslation((Vector3fc)this.deviceOffsets[2]);
            this.hmdPoseLeftEye.m30(-this.dh.vrSettings.nullvrIPD * 0.5f);
            this.hmdPoseRightEye.m30(this.dh.vrSettings.nullvrIPD * 0.5f);
            for (int i = 3; i < 10; ++i) {
                if (this.deviceSource[i].source == DeviceSource.Source.OSC && this.oscTrackers.trackers[this.deviceSource[i].deviceIndex].isTracking()) continue;
                this.deviceSource[i].set(DeviceSource.Source.NULL, i < (this.fbtMode == FBTMode.ARMS_LEGS ? 6 : (this.fbtMode == FBTMode.WITH_JOINTS ? 10 : 0)) ? i : -1);
                this.controllerPose[i].rotation((Quaternionfc)this.deviceRotations[i]);
                this.controllerPose[i].setTranslation((Vector3fc)this.deviceOffsets[i]);
            }
            this.updateAim();
            this.dh.vrSettings.xSensitivity = xSens;
            this.dh.vrSettings.keyholeX = xKey;
            if (this.dh.vrSettings.seated) {
                this.hmdRotation.set3x3(this.handRotation[0]);
                if (GuiHandler.GUI_ROTATION_ROOM != null) {
                    this.hmdRotation.set3x3(GuiHandler.GUI_ROTATION_ROOM);
                }
            }
            this.mc.getProfiler().popPush("processInputs");
            this.processInputs();
            this.mc.getProfiler().popPush("hmdSampling");
            this.hmdSampling();
            this.mc.getProfiler().pop();
        }
    }

    @Override
    public void processInputs() {
        this.ignorePressesNextFrame = false;
    }

    @Override
    protected ControllerType findActiveBindingControllerType(KeyMapping keyMapping) {
        return null;
    }

    @Override
    public void refreshControllerTransforms() {
    }

    @Override
    public Matrix4fc getControllerComponentTransform(int controllerIndex, String componentName) {
        return switch (componentName) {
            case "tip" -> {
                if (controllerIndex == 0) {
                    yield this.controllerType.tipR;
                }
                yield this.controllerType.tipL;
            }
            case "handgrip" -> {
                if (controllerIndex == 0) {
                    yield this.controllerType.handGripR;
                }
                yield this.controllerType.handGripL;
            }
            default -> new Matrix4f();
        };
    }

    @Override
    public String getOriginName(long origin) {
        return "NullDriver";
    }

    @Override
    public boolean hasCameraTracker() {
        return false;
    }

    @Override
    public List<Triple<DeviceSource, Integer, Matrix4fc>> getTrackers() {
        List<Triple<DeviceSource, Integer, Matrix4fc>> trackers = super.getTrackers();
        int trackerCount = this.fbtMode == FBTMode.ARMS_LEGS ? 3 : (this.fbtMode == FBTMode.WITH_JOINTS ? 7 : 0);
        Vector3f offset = new Vector3f();
        if (!this.dh.vrSettings.seated && this.dh.vrSettings.allowStandingOriginOffset && this.dh.vr.isHMDTracking()) {
            offset.set((Vector3fc)this.dh.vrSettings.originOffset);
        }
        for (int i = 3; i < 3 + trackerCount; ++i) {
            int type = -1;
            for (int t2 = 0; t2 < 10; ++t2) {
                if (!this.deviceSource[t2].is(DeviceSource.Source.NULL, i)) continue;
                type = t2;
                break;
            }
            int finalI = i;
            if (!trackers.stream().noneMatch(t -> ((DeviceSource)t.getLeft()).is(DeviceSource.Source.NULL, finalI))) continue;
            trackers.add((Triple<DeviceSource, Integer, Matrix4fc>)Triple.of((Object)new DeviceSource(DeviceSource.Source.NULL, i), (Object)type, (Object)new Matrix4f().rotation((Quaternionfc)this.deviceRotations[i]).setTranslation(this.deviceOffsets[i].x + offset.x, this.deviceOffsets[i].y + offset.y, this.deviceOffsets[i].z + offset.z)));
        }
        return trackers;
    }

    @Override
    public List<Long> getOrigins(VRInputAction action) {
        return List.of();
    }

    @Override
    public VRRenderer createVRRenderer() {
        return new NullVRStereoRenderer(this);
    }

    @Override
    public boolean isActive() {
        return this.vrActive;
    }

    @Override
    public boolean capFPS() {
        return true;
    }

    @Override
    public float getIPD() {
        return this.dh.vrSettings.nullvrIPD;
    }

    @Override
    public String getRuntimeName() {
        return "Null";
    }

    @Override
    public boolean handleKeyboardInputs(int key, int scanCode, int action, int modifiers) {
        boolean triggered = false;
        if (MethodHolder.isKeyDown(345)) {
            if (action == 1) {
                int offset;
                if (key == 295) {
                    this.vrActive = !this.vrActive;
                    return true;
                }
                if (key == 334) {
                    NullVR.MOD.keyVRInteract.pressKey(ControllerType.LEFT);
                    NullVR.MOD.keyVRInteract.pressKey(ControllerType.RIGHT);
                    return true;
                }
                int n = offset = MethodHolder.isKeyDown(346) ? -1 : 1;
                if (key == 298) {
                    this.controllerType = ClientUtils.getNextEnum(this.controllerType, offset);
                    if (this.controllerType == ControllerTransform.AUTO) {
                        this.controllerType = ClientUtils.getNextEnum(this.controllerType, offset);
                    }
                    Vector3f tipForward = this.controllerType.tipR.transformDirection(MathUtils.BACK, new Vector3f());
                    Vector3f handForward = this.controllerType.handGripR.transformDirection(MathUtils.BACK, new Vector3f());
                    this.gunAngle = (float)Math.toDegrees(Math.acos(Math.abs(tipForward.dot((Vector3fc)handForward))));
                    this.gunStyle = this.gunAngle > 10.0f;
                    MirrorNotification.notify("Changed to controller: " + String.valueOf(this.controllerType), false, 1000);
                    triggered = true;
                } else if (key == 325) {
                    this.currentBodyPart = ClientUtils.getNextEnum(this.currentBodyPart, offset);
                    MirrorNotification.notify("Changed selected body part to: " + String.valueOf((Object)this.currentBodyPart), false, 1000);
                    triggered = true;
                } else if (key == 321) {
                    this.fbtMode = ClientUtils.getNextEnum(this.fbtMode, offset);
                    MirrorNotification.notify("Changed fbt mode to: " + String.valueOf((Object)this.fbtMode), false, 1000);
                    triggered = true;
                } else if (key == 332) {
                    this.syncBodyparts = !this.syncBodyparts;
                    MirrorNotification.notify("toggled body part sync to : " + this.syncBodyparts, false, 1000);
                    triggered = true;
                } else if (key == 331) {
                    this.moveRoom = !this.moveRoom;
                    MirrorNotification.notify("toggled body part room relative to : " + this.moveRoom, false, 1000);
                    triggered = true;
                }
            }
            if (action != 0) {
                if (MethodHolder.isKeyDown(346)) {
                    if (key == 328) {
                        this.rotateBody(-0.17453294f, MathUtils.RIGHT);
                        triggered = true;
                    }
                    if (key == 322) {
                        this.rotateBody(0.17453294f, MathUtils.RIGHT);
                        triggered = true;
                    }
                    if (key == 324) {
                        this.rotateBody(0.17453294f, MathUtils.UP);
                        triggered = true;
                    }
                    if (key == 326) {
                        this.rotateBody(-0.17453294f, MathUtils.UP);
                        triggered = true;
                    }
                    if (key == 329) {
                        this.rotateBody(0.17453294f, MathUtils.BACK);
                        triggered = true;
                    }
                    if (key == 327) {
                        this.rotateBody(-0.17453294f, MathUtils.BACK);
                        triggered = true;
                    }
                } else {
                    if (key == 328) {
                        this.translateBody(0.0f, 0.0f, -0.01f);
                        triggered = true;
                    }
                    if (key == 322) {
                        this.translateBody(0.0f, 0.0f, 0.01f);
                        triggered = true;
                    }
                    if (key == 324) {
                        this.translateBody(-0.01f, 0.0f, 0.0f);
                        triggered = true;
                    }
                    if (key == 326) {
                        this.translateBody(0.01f, 0.0f, 0.0f);
                        triggered = true;
                    }
                    if (key == 329) {
                        this.translateBody(0.0f, 0.01f, 0.0f);
                        triggered = true;
                    }
                    if (key == 323) {
                        this.translateBody(0.0f, -0.01f, 0.0f);
                        triggered = true;
                    }
                }
            }
        }
        return triggered;
    }

    private void rotateBody(float angle, Vector3fc axis) {
        this.deviceRotations[this.currentBodyPart.rightIndex].rotateAxis(angle, axis);
        if (this.currentBodyPart.leftIndex != -1 && this.syncBodyparts) {
            if (axis == MathUtils.RIGHT) {
                this.deviceRotations[this.currentBodyPart.leftIndex].rotateAxis(angle, axis);
            } else {
                this.deviceRotations[this.currentBodyPart.leftIndex].rotateAxis(-angle, axis);
            }
        }
    }

    private void translateBody(float x, float y, float z) {
        if (this.moveRoom) {
            this.deviceOffsets[this.currentBodyPart.rightIndex].add(x, y, z);
        } else {
            this.deviceOffsets[this.currentBodyPart.rightIndex].add((Vector3fc)this.deviceRotations[this.currentBodyPart.rightIndex].transform(x, y, z, new Vector3f()));
        }
        if (this.currentBodyPart.leftIndex != -1 && this.syncBodyparts) {
            if (this.moveRoom) {
                this.deviceOffsets[this.currentBodyPart.leftIndex].add(-x, y, z);
            } else {
                this.deviceOffsets[this.currentBodyPart.leftIndex].add((Vector3fc)this.deviceRotations[this.currentBodyPart.leftIndex].transform(x, y, z, new Vector3f()));
            }
        }
    }
}

