/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import org.vivecraft.client.gui.framework.screens.TwoHandedScreen;
import org.vivecraft.client.gui.framework.widgets.ColoredKeyButton;
import org.vivecraft.client_vr.gui.keyboard.KeyboardKeys;

public class GuiKeyboard
extends TwoHandedScreen {
    private boolean isShift = false;

    public void init() {
        int y;
        this.clearWidgets();
        KeyboardKeys.Layout layout = KeyboardKeys.getRegularKeys(this.isShift, () -> {});
        int margin = 32;
        int spacing = 2;
        int buttonWidth = 25;
        int specialWidth = 30;
        int offset = specialWidth - (buttonWidth * 2 + spacing);
        for (KeyboardKeys.Key key : layout.keys()) {
            y = key.y() < 0 ? layout.rows() - key.y() : key.y();
            this.addRenderableWidget((GuiEventListener)new ColoredKeyButton(key, key.x() * (buttonWidth + spacing) + offset, margin + (y - 1) * (20 + spacing), buttonWidth, 20));
        }
        for (KeyboardKeys.Key key : KeyboardKeys.getSpecialKeys(() -> this.setShift(!this.isShift))) {
            int width;
            if (key.width() == 1) {
                key = new KeyboardKeys.Key(key.id(), key.x() - 2, key.y() + layout.rows() - 4, key.width(), key.height(), key.label(), key.onPress(), key.onRelease());
            }
            y = key.y() < 0 ? layout.rows() - key.y() : key.y();
            int xPos = (key.x() > 0 ? offset : 0) + key.x() * (buttonWidth + spacing);
            int n = width = key.x() == 0 ? specialWidth : key.width() * buttonWidth + (key.width() - 1) * spacing;
            if (xPos + width > this.width) {
                width -= xPos + width - this.width;
            }
            this.addRenderableWidget((GuiEventListener)new ColoredKeyButton(key, xPos, margin + (y - 1) * (20 + spacing), width, 20));
        }
        this.dh.vrSettings.physicalKeyboardTheme.theme.reload();
    }

    public void setShift(boolean shift) {
        if (shift != this.isShift) {
            this.isShift = shift;
            this.reinit = true;
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, "Keyboard", this.width / 2, 2, -1);
        super.render(guiGraphics, 0, 0, partialTick);
    }
}

