/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.render.armor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.vivecraft.client.render.models.HandModel;
import org.vivecraft.client.utils.ModelUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;

public class VRArmorModel_WithArms<T extends LivingEntity>
extends HumanoidArmorModel<T>
implements HandModel {
    public final ModelPart leftHand;
    public final ModelPart rightHand;

    public VRArmorModel_WithArms(ModelPart root) {
        super(root);
        this.leftHand = root.getChild("left_hand");
        this.rightHand = root.getChild("right_hand");
        ModelUtils.textureHack(this.leftArm, this.leftHand);
        ModelUtils.textureHack(this.rightArm, this.rightHand);
    }

    public static MeshDefinition createBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = HumanoidArmorModel.createBodyLayer((CubeDeformation)cubeDeformation);
        PartDefinition partDefinition = meshDefinition.getRoot();
        boolean connected = ClientDataHolderVR.getInstance().vrSettings.playerLimbsConnected;
        int upperExtension = connected ? 3 : 0;
        int lowerExtension = connected ? 2 : 0;
        float lowerShrinkage = connected ? -0.05f : 0.0f;
        partDefinition.addOrReplaceChild("left_hand", CubeListBuilder.create().texOffs(40, 23 - lowerExtension).addBox(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(lowerShrinkage)), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_hand", CubeListBuilder.create().texOffs(40, 23 - lowerExtension).addBox(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(lowerShrinkage)), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
        partDefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        return meshDefinition;
    }

    protected Iterable<ModelPart> bodyParts() {
        return Iterables.concat((Iterable)super.bodyParts(), (Iterable)ImmutableList.of((Object)this.leftHand, (Object)this.rightHand));
    }

    @Override
    public ModelPart getLeftHand() {
        return this.leftHand;
    }

    @Override
    public ModelPart getRightHand() {
        return this.rightHand;
    }

    public void setAllVisible(boolean visible) {
        super.setAllVisible(visible);
        this.leftHand.visible = visible;
        this.rightHand.visible = visible;
    }
}

