/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.screens;

import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import org.vivecraft.client.gui.framework.TooltipRenderer;
import org.vivecraft.client.gui.framework.VROptionEntry;
import org.vivecraft.client.gui.framework.VROptionLayout;
import org.vivecraft.client.gui.framework.widgets.GuiVROption;
import org.vivecraft.client.gui.framework.widgets.GuiVROptionButton;
import org.vivecraft.client.gui.framework.widgets.GuiVROptionSlider;
import org.vivecraft.client.gui.settings.GuiAllSettings;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.TooltipUtil;

public abstract class GuiVROptionsBase
extends Screen {
    private static final ResourceLocation SEARCH_ICON = ResourceLocation.fromNamespaceAndPath((String)"vivecraft", (String)"icon/search");
    protected ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
    protected final Screen lastScreen;
    protected final VRSettings vrSettings;
    protected boolean reinit;
    protected boolean drawDefaultButtons = true;
    protected ObjectSelectionList visibleList = null;
    private int nextButtonIndex = 0;
    public String vrTitle = "Title";
    private Button btnDone;
    private Button btnDefaults;

    public GuiVROptionsBase(Screen lastScreen) {
        super((Component)Component.literal((String)""));
        this.lastScreen = lastScreen;
        this.vrSettings = ClientDataHolderVR.getInstance().vrSettings;
    }

    protected void addDefaultButtons() {
        SpriteIconButton search = SpriteIconButton.builder((Component)Component.translatable((String)"vivecraft.options.screen.search"), p -> this.minecraft.setScreen((Screen)new GuiAllSettings(this)), (boolean)true).sprite(SEARCH_ICON, 15, 15).size(20, 20).build();
        if (this.width > 360) {
            search.setX(this.width / 2 - 180);
            search.setY((int)Math.ceil((float)(this.height / 6) - 10.0f));
        } else {
            search.setX(this.width / 2 - 155);
            search.setY((int)Math.ceil((float)(this.height / 6) - 31.0f));
        }
        search.setTooltip(Tooltip.create((Component)Component.translatable((String)"vivecraft.options.screen.search")));
        this.addRenderableWidget((GuiEventListener)search);
        this.btnDone = new Button.Builder((Component)Component.translatable((String)"gui.back"), p -> {
            if (!this.onDoneClicked()) {
                this.dataHolder.vrSettings.saveOptions();
                this.minecraft.setScreen(this.lastScreen);
            }
        }).pos(this.width / 2 + 5, this.height - 30).size(150, 20).build();
        this.addRenderableWidget((GuiEventListener)this.btnDone);
        this.btnDefaults = new Button.Builder((Component)Component.translatable((String)"vivecraft.gui.loaddefaults"), p -> {
            this.loadDefaults();
            this.dataHolder.vrSettings.saveOptions();
            this.reinit = true;
        }).pos(this.width / 2 - 155, this.height - 30).size(150, 20).build();
        this.addRenderableWidget((GuiEventListener)this.btnDefaults);
        this.children().sort((a, b) -> {
            if (a instanceof AbstractWidget) {
                AbstractWidget wA = (AbstractWidget)a;
                if (b instanceof AbstractWidget) {
                    AbstractWidget wB = (AbstractWidget)b;
                    if (wA.getY() < wB.getY() || wA.getY() == wB.getY() && wA.getX() < wB.getX()) {
                        return -1;
                    }
                    return 1;
                }
            }
            return 0;
        });
    }

    protected boolean onDoneClicked() {
        return false;
    }

    protected void init(VROptionLayout[] settings, boolean clear) {
        if (clear) {
            this.clearWidgets();
        }
        for (final VROptionLayout layout : settings) {
            if (layout.getOption() != null && layout.getOption().getEnumFloat()) {
                this.addRenderableWidget((GuiEventListener)new GuiVROptionSlider(this, layout.getOrdinal(), layout.getX(this.width), layout.getY(this.height), layout.getOption()){

                    public void onClick(double mouseX, double mouseY) {
                        if (layout.getCustomHandler() == null || !layout.getCustomHandler().apply(this, new Vec2((float)mouseX, (float)mouseY)).booleanValue()) {
                            super.onClick(mouseX, mouseY);
                        }
                    }
                });
                continue;
            }
            if (layout.getOption() != null) {
                this.addRenderableWidget((GuiEventListener)new GuiVROptionButton(layout.getOrdinal(), layout.getX(this.width), layout.getY(this.height), layout.getOption(), layout.getButtonText(), p -> {
                    if (layout.getCustomHandler() == null || !layout.getCustomHandler().apply((GuiVROptionButton)p, new Vec2(0.0f, 0.0f)).booleanValue()) {
                        this.vrSettings.setOptionValue(((GuiVROptionButton)p).getOption());
                        p.setMessage((Component)Component.literal((String)layout.getButtonText()));
                    }
                }));
                continue;
            }
            if (layout.getScreen() != null) {
                this.addRenderableWidget((GuiEventListener)new GuiVROptionButton(layout.getOrdinal(), layout.getX(this.width), layout.getY(this.height), layout.getButtonText(), p -> {
                    try {
                        if (layout.getCustomHandler() != null && layout.getCustomHandler().apply((GuiVROptionButton)p, new Vec2(0.0f, 0.0f)).booleanValue()) {
                            return;
                        }
                        this.vrSettings.saveOptions();
                        this.minecraft.setScreen(layout.getScreen().getConstructor(Screen.class).newInstance(new Object[]{this}));
                    }
                    catch (ReflectiveOperationException e) {
                        VRSettings.LOGGER.error("Vivecraft: error setting screen: ", (Throwable)e);
                    }
                }));
                continue;
            }
            if (layout.getCustomHandler() != null) {
                this.addRenderableWidget((GuiEventListener)new GuiVROptionButton(layout.getOrdinal(), layout.getX(this.width), layout.getY(this.height), layout.getButtonText(), p -> layout.getCustomHandler().apply((GuiVROptionButton)p, new Vec2(0.0f, 0.0f))));
                continue;
            }
            this.addRenderableWidget((GuiEventListener)new GuiVROptionButton(layout.getOrdinal(), layout.getX(this.width), layout.getY(this.height), layout.getButtonText(), p -> {}));
        }
    }

    protected void loadDefaults() {
        for (GuiEventListener child : this.children()) {
            if (!(child instanceof GuiVROption)) continue;
            GuiVROption optionButton = (GuiVROption)child;
            this.vrSettings.loadDefault(optionButton.getOption());
        }
    }

    protected void init(VROptionEntry[] settings, boolean clear) {
        if (clear) {
            this.clearWidgets();
            this.nextButtonIndex = 0;
        }
        ArrayList<VROptionLayout> layouts = new ArrayList<VROptionLayout>();
        if (this.nextButtonIndex < this.children().size()) {
            this.nextButtonIndex = this.children().size();
        }
        int nextIndex = this.nextButtonIndex;
        for (VROptionEntry setting : settings) {
            VROptionLayout.Position pos;
            VROptionLayout.Position position = setting.center ? VROptionLayout.Position.POS_CENTER : (pos = nextIndex % 2 == 0 ? VROptionLayout.Position.POS_LEFT : VROptionLayout.Position.POS_RIGHT);
            if (setting.center && nextIndex % 2 != 0) {
                ++nextIndex;
            }
            if (setting.option != null) {
                if (setting.option != VRSettings.VrOptions.DUMMY) {
                    layouts.add(new VROptionLayout(setting.option, setting.customHandler, pos, (float)Math.floor((float)nextIndex / 2.0f), true, setting.title));
                }
            } else if (setting.customHandler != null) {
                layouts.add(new VROptionLayout(setting.customHandler, pos, (float)Math.floor((float)nextIndex / 2.0f), true, setting.title));
            }
            if (setting.center) {
                ++nextIndex;
            }
            ++nextIndex;
        }
        this.nextButtonIndex = nextIndex;
        this.init(layouts.toArray(new VROptionLayout[0]), false);
    }

    protected void init(VRSettings.VrOptions[] settings, boolean clear) {
        VROptionEntry[] entries = new VROptionEntry[settings.length];
        for (int i = 0; i < settings.length; ++i) {
            entries[i] = new VROptionEntry(settings[i]);
        }
        this.init(entries, clear);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.reinit) {
            VRSettings.VrOptions vrOptions;
            this.reinit = false;
            GuiEventListener guiEventListener = this.getFocused();
            if (guiEventListener instanceof GuiVROption) {
                GuiVROption option = (GuiVROption)guiEventListener;
                vrOptions = option.getOption();
            } else {
                vrOptions = null;
            }
            VRSettings.VrOptions selected = vrOptions;
            this.init();
            if (selected != null) {
                GuiEventListener newButton = this.children().stream().filter(listener -> {
                    GuiVROption option;
                    return listener instanceof GuiVROption && (option = (GuiVROption)listener).getOption() == selected;
                }).findFirst().orElse(null);
                this.setFocused(newButton);
            }
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.visibleList != null) {
            this.visibleList.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)this.vrTitle), this.width / 2, 15, -1);
        if (this.btnDefaults != null) {
            this.btnDefaults.visible = this.drawDefaultButtons;
        }
        if (this.btnDone != null) {
            this.btnDone.visible = this.drawDefaultButtons;
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void actionPerformed(AbstractWidget widget) {
    }

    protected void actionPerformedRightClick(AbstractWidget widget) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        GuiEventListener guiEventListener;
        boolean success = super.mouseClicked(mouseX, mouseY, button);
        if (success && (guiEventListener = this.getFocused()) instanceof AbstractWidget) {
            AbstractWidget widget = (AbstractWidget)guiEventListener;
            if (button == 0) {
                this.actionPerformed(widget);
            } else if (button == 1) {
                this.actionPerformedRightClick(widget);
            }
        } else if (this.visibleList != null) {
            return this.visibleList.mouseClicked(mouseX, mouseY, button);
        }
        return success;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.visibleList != null ? this.visibleList.mouseReleased(mouseX, mouseY, button) : super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.visibleList != null ? this.visibleList.mouseDragged(mouseX, mouseY, button, dragX, dragY) : super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.visibleList != null) {
            this.visibleList.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (!this.onDoneClicked()) {
                this.dataHolder.vrSettings.saveOptions();
                this.minecraft.setScreen(this.lastScreen);
            }
            return true;
        }
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            GuiEventListener guiEventListener = this.getFocused();
            if (guiEventListener instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)guiEventListener;
                this.actionPerformed(widget);
            }
            return true;
        }
        return this.visibleList != null && this.visibleList.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return this.visibleList != null && this.visibleList.charTyped(codePoint, modifiers) || super.charTyped(codePoint, modifiers);
    }

    private void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        GuiVROption guiHover;
        GuiEventListener hover = null;
        if (this.minecraft.getLastInputType().isKeyboard()) {
            hover = this.getFocused();
        }
        if (hover == null) {
            for (GuiEventListener child : this.children()) {
                AbstractWidget widget;
                if (!(child instanceof AbstractWidget) || !this.isMouseOver(widget = (AbstractWidget)child, mouseX, mouseY)) continue;
                hover = child;
            }
        }
        if (hover instanceof GuiVROption && (guiHover = (GuiVROption)hover).getOption() != null && this.deferredTooltipRendering == null) {
            TooltipRenderer.renderTooltip(guiGraphics, TooltipUtil.getClientConfigTooltip(guiHover.getOption()), this.width / 2, guiHover.getY(), guiHover.getHeight());
        }
    }

    private boolean isMouseOver(AbstractWidget widget, double mouseX, double mouseY) {
        return widget.visible && mouseX >= (double)widget.getX() && mouseY >= (double)widget.getY() && mouseX < (double)(widget.getX() + widget.getWidth()) && mouseY < (double)(widget.getY() + widget.getHeight());
    }
}

