/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class VRBlockQueue {
    protected VRBlockQueue() {
        throw new UnsupportedOperationException();
    }

    public static int nVRBlockQueue_Create(long pulQueueHandle, long pchPath, int unBlockDataSize, int unBlockHeaderSize, int unBlockCount, int unFlags) {
        long __functionAddress = OpenVR.VRBlockQueue.Create;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)pulQueueHandle, (long)pchPath, (int)unBlockDataSize, (int)unBlockHeaderSize, (int)unBlockCount, (int)unFlags, (long)__functionAddress);
    }

    @NativeType(value="EBlockQueueError")
    public static int VRBlockQueue_Create(@NativeType(value="PropertyContainerHandle_t *") LongBuffer pulQueueHandle, @Nullable @NativeType(value="char *") ByteBuffer pchPath, @NativeType(value="uint32_t") int unBlockDataSize, @NativeType(value="uint32_t") int unBlockHeaderSize, @NativeType(value="uint32_t") int unBlockCount, @NativeType(value="uint32_t") int unFlags) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pulQueueHandle, (int)1);
            Checks.checkNT1Safe((ByteBuffer)pchPath);
        }
        return VRBlockQueue.nVRBlockQueue_Create(MemoryUtil.memAddress((LongBuffer)pulQueueHandle), MemoryUtil.memAddressSafe((ByteBuffer)pchPath), unBlockDataSize, unBlockHeaderSize, unBlockCount, unFlags);
    }

    public static int nVRBlockQueue_Connect(long pulQueueHandle, long pchPath) {
        long __functionAddress = OpenVR.VRBlockQueue.Connect;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)pulQueueHandle, (long)pchPath, (long)__functionAddress);
    }

    @NativeType(value="EBlockQueueError")
    public static int VRBlockQueue_Connect(@NativeType(value="PropertyContainerHandle_t *") LongBuffer pulQueueHandle, @Nullable @NativeType(value="char *") ByteBuffer pchPath) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pulQueueHandle, (int)1);
            Checks.checkNT1Safe((ByteBuffer)pchPath);
        }
        return VRBlockQueue.nVRBlockQueue_Connect(MemoryUtil.memAddress((LongBuffer)pulQueueHandle), MemoryUtil.memAddressSafe((ByteBuffer)pchPath));
    }

    @NativeType(value="EBlockQueueError")
    public static int VRBlockQueue_Destroy(@NativeType(value="PropertyContainerHandle_t") long ulQueueHandle) {
        long __functionAddress = OpenVR.VRBlockQueue.Destroy;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJI((long)ulQueueHandle, (long)__functionAddress);
    }

    public static int nVRBlockQueue_AcquireWriteOnlyBlock(long ulQueueHandle, long pulBlockHandle, long ppvBuffer) {
        long __functionAddress = OpenVR.VRBlockQueue.AcquireWriteOnlyBlock;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJPPI((long)ulQueueHandle, (long)pulBlockHandle, (long)ppvBuffer, (long)__functionAddress);
    }

    @NativeType(value="EBlockQueueError")
    public static int VRBlockQueue_AcquireWriteOnlyBlock(@NativeType(value="PropertyContainerHandle_t") long ulQueueHandle, @NativeType(value="PropertyContainerHandle_t *") LongBuffer pulBlockHandle, @NativeType(value="void **") PointerBuffer ppvBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pulBlockHandle, (int)1);
            Checks.check((CustomBuffer)ppvBuffer, (int)1);
        }
        return VRBlockQueue.nVRBlockQueue_AcquireWriteOnlyBlock(ulQueueHandle, MemoryUtil.memAddress((LongBuffer)pulBlockHandle), MemoryUtil.memAddress((CustomBuffer)ppvBuffer));
    }

    @NativeType(value="EBlockQueueError")
    public static int VRBlockQueue_ReleaseWriteOnlyBlock(@NativeType(value="PropertyContainerHandle_t") long ulQueueHandle, @NativeType(value="PropertyContainerHandle_t") long ulBlockHandle) {
        long __functionAddress = OpenVR.VRBlockQueue.ReleaseWriteOnlyBlock;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJJI((long)ulQueueHandle, (long)ulBlockHandle, (long)__functionAddress);
    }

    public static int nVRBlockQueue_WaitAndAcquireReadOnlyBlock(long ulQueueHandle, long pulBlockHandle, long ppvBuffer, int eReadType, int unTimeoutMs) {
        long __functionAddress = OpenVR.VRBlockQueue.WaitAndAcquireReadOnlyBlock;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJPPI((long)ulQueueHandle, (long)pulBlockHandle, (long)ppvBuffer, (int)eReadType, (int)unTimeoutMs, (long)__functionAddress);
    }

    @NativeType(value="EBlockQueueError")
    public static int VRBlockQueue_WaitAndAcquireReadOnlyBlock(@NativeType(value="PropertyContainerHandle_t") long ulQueueHandle, @NativeType(value="PropertyContainerHandle_t *") LongBuffer pulBlockHandle, @NativeType(value="void **") PointerBuffer ppvBuffer, @NativeType(value="EBlockQueueReadType") int eReadType, @NativeType(value="uint32_t") int unTimeoutMs) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pulBlockHandle, (int)1);
            Checks.check((CustomBuffer)ppvBuffer, (int)1);
        }
        return VRBlockQueue.nVRBlockQueue_WaitAndAcquireReadOnlyBlock(ulQueueHandle, MemoryUtil.memAddress((LongBuffer)pulBlockHandle), MemoryUtil.memAddress((CustomBuffer)ppvBuffer), eReadType, unTimeoutMs);
    }

    public static int nVRBlockQueue_AcquireReadOnlyBlock(long ulQueueHandle, long pulBlockHandle, long ppvBuffer, int eReadType) {
        long __functionAddress = OpenVR.VRBlockQueue.AcquireReadOnlyBlock;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJPPI((long)ulQueueHandle, (long)pulBlockHandle, (long)ppvBuffer, (int)eReadType, (long)__functionAddress);
    }

    @NativeType(value="EBlockQueueError")
    public static int VRBlockQueue_AcquireReadOnlyBlock(@NativeType(value="PropertyContainerHandle_t") long ulQueueHandle, @NativeType(value="PropertyContainerHandle_t *") LongBuffer pulBlockHandle, @NativeType(value="void **") PointerBuffer ppvBuffer, @NativeType(value="EBlockQueueReadType") int eReadType) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pulBlockHandle, (int)1);
            Checks.check((CustomBuffer)ppvBuffer, (int)1);
        }
        return VRBlockQueue.nVRBlockQueue_AcquireReadOnlyBlock(ulQueueHandle, MemoryUtil.memAddress((LongBuffer)pulBlockHandle), MemoryUtil.memAddress((CustomBuffer)ppvBuffer), eReadType);
    }

    @NativeType(value="EBlockQueueError")
    public static int VRBlockQueue_ReleaseReadOnlyBlock(@NativeType(value="PropertyContainerHandle_t") long ulQueueHandle, @NativeType(value="PropertyContainerHandle_t") long ulBlockHandle) {
        long __functionAddress = OpenVR.VRBlockQueue.ReleaseReadOnlyBlock;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJJI((long)ulQueueHandle, (long)ulBlockHandle, (long)__functionAddress);
    }

    public static int nVRBlockQueue_QueueHasReader(long ulQueueHandle, long pbHasReaders) {
        long __functionAddress = OpenVR.VRBlockQueue.QueueHasReader;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJPI((long)ulQueueHandle, (long)pbHasReaders, (long)__functionAddress);
    }

    @NativeType(value="EBlockQueueError")
    public static int VRBlockQueue_QueueHasReader(@NativeType(value="PropertyContainerHandle_t") long ulQueueHandle, @NativeType(value="bool *") ByteBuffer pbHasReaders) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pbHasReaders, (int)1);
        }
        return VRBlockQueue.nVRBlockQueue_QueueHasReader(ulQueueHandle, MemoryUtil.memAddress((ByteBuffer)pbHasReaders));
    }
}

