/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import journeymap.common.network.model.PlayerLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerRadarManager {
    private final Map<UUID, Player> playersOnServer;
    private static PlayerRadarManager INSTANCE;
    private final Object lock = new Object();

    private PlayerRadarManager() {
        this.playersOnServer = new HashMap<UUID, Player>();
    }

    public static PlayerRadarManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlayerRadarManager();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<UUID, Player> getPlayers() {
        Object object = this.lock;
        synchronized (object) {
            return this.playersOnServer;
        }
    }

    public void reset() {
        this.playersOnServer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(UUID playerId) {
        Object object = this.lock;
        synchronized (object) {
            this.playersOnServer.remove(playerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlayers(PlayerLocation player) {
        Object object = this.lock;
        synchronized (object) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player != null && mc.getConnection() != null && mc.getConnection().getPlayerInfo(player.getUniqueId()) != null) {
                Player playerEntity = this.buildPlayer(player);
                this.playersOnServer.put(player.getUniqueId(), playerEntity);
            }
        }
    }

    private Player buildPlayer(PlayerLocation player) {
        Minecraft mc = Minecraft.getInstance();
        if (!player.getUniqueId().equals(mc.player.getUUID()) && player.isVisible()) {
            Player fakeRadarPlayer;
            if (this.getPlayers().get(player.getUniqueId()) == null) {
                PlayerInfo info = mc.getConnection().getPlayerInfo(player.getUniqueId());
                fakeRadarPlayer = new RemotePlayer(mc.level, info.getProfile());
            } else {
                fakeRadarPlayer = this.getPlayers().get(player.getUniqueId());
            }
            float f = (float)(player.getYaw() * 360) / 256.0f;
            float f1 = (float)(player.getPitch() * 360) / 256.0f;
            fakeRadarPlayer.setId(player.getEntityId());
            fakeRadarPlayer.setPos(player.getX(), player.getY(), player.getZ());
            fakeRadarPlayer.syncPacketPositionCodec(player.getX(), player.getY(), player.getZ());
            fakeRadarPlayer.absMoveTo(player.getX(), player.getY(), player.getZ(), f, f1);
            fakeRadarPlayer.setShiftKeyDown(false);
            return fakeRadarPlayer;
        }
        return null;
    }
}

