/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.threadtweak.mixin;

import com.leclowndu93150.threadtweak.SmoothBoot;
import com.leclowndu93150.threadtweak.util.LoggingForkJoinWorkerThread;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.Util;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Util.class})
public abstract class UtilMixin {
    @Shadow
    @Final
    @Mutable
    private static ExecutorService BACKGROUND_EXECUTOR;
    @Shadow
    @Final
    @Mutable
    private static ExecutorService IO_POOL;

    @Shadow
    private static void onThreadException(Thread thread, Throwable throwable) {
    }

    @Inject(method={"backgroundExecutor"}, at={@At(value="HEAD")})
    private static void onGetMainWorkerExecutor(CallbackInfoReturnable<Executor> ci) {
        if (!SmoothBoot.initMainWorker) {
            BACKGROUND_EXECUTOR = UtilMixin.replWorker("Main");
            SmoothBoot.LOGGER.debug("Main worker replaced");
            SmoothBoot.initMainWorker = true;
        }
    }

    @Inject(method={"ioPool"}, at={@At(value="HEAD")})
    private static void onGetIoWorkerExecutor(CallbackInfoReturnable<Executor> ci) {
        if (!SmoothBoot.initIOWorker) {
            IO_POOL = UtilMixin.replIoWorker();
            SmoothBoot.LOGGER.debug("IO worker replaced");
            SmoothBoot.initIOWorker = true;
        }
    }

    private static ExecutorService replWorker(String name) {
        if (!SmoothBoot.initConfig) {
            SmoothBoot.regConfig();
            SmoothBoot.initConfig = true;
        }
        AtomicInteger atomicInteger = new AtomicInteger(1);
        return new ForkJoinPool(Mth.clamp((int)UtilMixin.select(name, SmoothBoot.config.threadCount.bootstrap, SmoothBoot.config.threadCount.main), (int)1, (int)Short.MAX_VALUE), forkJoinPool -> {
            String workerName = "Worker-" + name + "-" + atomicInteger.getAndIncrement();
            SmoothBoot.LOGGER.debug("Initialized " + workerName);
            LoggingForkJoinWorkerThread forkJoinWorkerThread = new LoggingForkJoinWorkerThread(forkJoinPool, SmoothBoot.LOGGER);
            forkJoinWorkerThread.setPriority(UtilMixin.select(name, SmoothBoot.config.threadPriority.bootstrap, SmoothBoot.config.threadPriority.main));
            forkJoinWorkerThread.setName(workerName);
            return forkJoinWorkerThread;
        }, UtilMixin::onThreadException, true);
    }

    private static ExecutorService replIoWorker() {
        AtomicInteger atomicInteger = new AtomicInteger(1);
        return Executors.newCachedThreadPool(runnable -> {
            String workerName = "IO-Worker-" + atomicInteger.getAndIncrement();
            SmoothBoot.LOGGER.debug("Initialized " + workerName);
            Thread thread = new Thread(runnable);
            thread.setName(workerName);
            thread.setDaemon(true);
            thread.setPriority(SmoothBoot.config.threadPriority.io);
            thread.setUncaughtExceptionHandler(UtilMixin::onThreadException);
            return thread;
        });
    }

    private static <T> T select(String name, T bootstrap, T main) {
        return Objects.equals(name, "Bootstrap") ? bootstrap : main;
    }
}

