/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PulleyBlockTile;
import net.mehvahdjukaar.supplementaries.integration.AmendmentsCompat;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RopeHelper {
    public static boolean addRopeDown(BlockPos pos, Level level, @Nullable Player player, InteractionHand hand, Block ropeBlock) {
        return RopeHelper.addRope(pos, level, player, hand, ropeBlock, Direction.DOWN, Integer.MAX_VALUE);
    }

    public static boolean addRope(BlockPos pos, Level level, @Nullable Player player, InteractionHand hand, Block ropeBlock, Direction moveDir, int maxDist) {
        BlockEntity blockEntity;
        BlockState state = level.getBlockState(pos);
        if (maxDist <= 0) {
            return false;
        }
        --maxDist;
        if (RopeHelper.isCorrectRope(ropeBlock, state, moveDir)) {
            return RopeHelper.addRope(pos.relative(moveDir), level, player, hand, ropeBlock, moveDir, maxDist);
        }
        if (state.getBlock() instanceof PulleyBlock && (blockEntity = level.getBlockEntity(pos)) instanceof PulleyBlockTile) {
            PulleyBlockTile te = (PulleyBlockTile)blockEntity;
            return te.rotateIndirect(player, hand, ropeBlock, moveDir, false);
        }
        return RopeHelper.placeAndMove(player, hand, level, pos, moveDir, ropeBlock);
    }

    public static boolean isCorrectRope(Block ropeBlock, BlockState state, Direction direction) {
        if (state.getBlock() instanceof ChainBlock && state.getValue((Property)ChainBlock.AXIS) != direction.getAxis()) {
            return false;
        }
        return ropeBlock == state.getBlock();
    }

    public static boolean placeAndMove(@Nullable Player player, InteractionHand hand, Level level, BlockPos originPos, Direction moveDir, @Nullable Block placeWhereItWas) {
        BlockEntity te;
        boolean needsToPush;
        BlockState originalState = level.getBlockState(originPos);
        BlockPos targetPos = originPos.relative(moveDir);
        BlockState targetState = level.getBlockState(targetPos);
        CompoundTag tileTag = null;
        boolean bl = needsToPush = !originalState.canBeReplaced();
        if (needsToPush) {
            if (!targetState.canBeReplaced() && placeWhereItWas != null) {
                return false;
            }
            if (!RopeHelper.isPushableByRopes(originalState, level, originPos, moveDir)) {
                return false;
            }
            BlockEntity tile = level.getBlockEntity(originPos);
            if (tile != null) {
                if (CompatHandler.QUARK && !QuarkCompat.canMoveBlockEntity(originalState)) {
                    return false;
                }
                tile.setRemoved();
                tileTag = tile.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            }
        }
        FluidState originalFluid = level.getFluidState(originPos);
        if (placeWhereItWas != null) {
            level.setBlock(originPos, originalFluid.createLegacyBlock(), 18);
            ItemStack stack = new ItemStack((ItemLike)placeWhereItWas);
            BlockPlaceContext context = new BlockPlaceContext(level, player, hand, stack, new BlockHitResult(Vec3.atCenterOf((Vec3i)originPos), moveDir.getOpposite(), originPos, false));
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                BlockItem bi = (BlockItem)item;
                InteractionResult placeResult = bi.place(context);
                if (placeResult == InteractionResult.PASS || placeResult == InteractionResult.FAIL) {
                    level.setBlock(originPos, originalState, 4);
                    return false;
                }
                if (!needsToPush) {
                    return true;
                }
            }
        } else {
            level.setBlockAndUpdate(originPos, originalFluid.createLegacyBlock());
        }
        FluidState targetFluid = level.getFluidState(targetPos);
        boolean waterFluid = targetFluid.is((Fluid)Fluids.WATER);
        if (originalState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            boolean canHoldWater = originalState.is(ModTags.WATER_HOLDER);
            if (!canHoldWater) {
                originalState = (BlockState)originalState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(waterFluid));
            }
        } else if (originalState.getBlock() instanceof AbstractCauldronBlock) {
            if (waterFluid && originalState.is(Blocks.CAULDRON) || originalState.is(Blocks.WATER_CAULDRON)) {
                originalState = (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3));
            } else if (targetFluid.is((Fluid)Fluids.LAVA) && originalState.is(Blocks.CAULDRON) || originalState.is(Blocks.LAVA_CAULDRON)) {
                originalState = Blocks.LAVA_CAULDRON.defaultBlockState();
            } else if (CompatHandler.AMENDMENTS) {
                originalState = AmendmentsCompat.fillCauldronWithFluid(level, targetPos, originalState, targetFluid);
            }
        }
        originalState = Block.updateFromNeighbourShapes((BlockState)originalState, (LevelAccessor)level, (BlockPos)targetPos);
        level.setBlockAndUpdate(targetPos, originalState);
        if (tileTag != null && (te = level.getBlockEntity(targetPos)) != null) {
            te.loadWithComponents(tileTag, (HolderLookup.Provider)level.registryAccess());
        }
        return true;
    }

    public static boolean removeRopeDown(BlockPos pos, Level level, Block ropeBlock) {
        return RopeHelper.removeRope(pos, level, ropeBlock, Direction.DOWN, Integer.MAX_VALUE);
    }

    public static boolean removeRope(BlockPos pos, Level level, Block ropeBlock, Direction moveUpDir, int maxDist) {
        PulleyBlockTile te;
        BlockEntity blockEntity;
        if (maxDist <= 0) {
            return false;
        }
        --maxDist;
        BlockState state = level.getBlockState(pos);
        if (RopeHelper.isCorrectRope(ropeBlock, state, moveUpDir)) {
            return RopeHelper.removeRope(pos.relative(moveUpDir), level, ropeBlock, moveUpDir, maxDist);
        }
        if (state.getBlock() instanceof PulleyBlock && (blockEntity = level.getBlockEntity(pos)) instanceof PulleyBlockTile && !(te = (PulleyBlockTile)blockEntity).isEmpty()) {
            return te.rotateIndirect(null, InteractionHand.MAIN_HAND, ropeBlock, moveUpDir, true);
        }
        BlockPos up = pos.relative(moveUpDir.getOpposite());
        if (level.getBlockState(up).getBlock() != ropeBlock) {
            return false;
        }
        if (!RopeHelper.placeAndMove(null, InteractionHand.MAIN_HAND, level, pos, moveUpDir.getOpposite(), null)) {
            level.setBlockAndUpdate(up, level.getFluidState(up).createLegacyBlock());
        }
        return true;
    }

    public static boolean isPushableByRopes(BlockState state, Level level, BlockPos pos, Direction moveDir) {
        if (state.getBlock() instanceof PulleyBlock) {
            return false;
        }
        if (state.is(ModTags.ROPE_PUSH_BLACKLIST)) {
            return false;
        }
        if (!state.isSolid()) {
            return false;
        }
        if (moveDir.getAxis().isVertical() && state.is(ModTags.ROPE_HANG_TAG)) {
            return true;
        }
        boolean couldBreak = !state.isSolid();
        return RopeHelper.isPushable(state, level, pos, moveDir, couldBreak, moveDir);
    }

    private static boolean isPushable(BlockState state, Level level, BlockPos pos, Direction movementDirection, boolean allowDestroy, Direction pistonFacing) {
        if (pos.getY() >= level.getMinBuildHeight() && pos.getY() <= level.getMaxBuildHeight() - 1 && level.getWorldBorder().isWithinBounds(pos)) {
            if (state.isAir()) {
                return true;
            }
            if (!(state.is(Blocks.OBSIDIAN) || state.is(Blocks.CRYING_OBSIDIAN) || state.is(Blocks.RESPAWN_ANCHOR) || state.is(Blocks.REINFORCED_DEEPSLATE))) {
                if (movementDirection == Direction.DOWN && pos.getY() == level.getMinBuildHeight()) {
                    return false;
                }
                if (movementDirection == Direction.UP && pos.getY() == level.getMaxBuildHeight() - 1) {
                    return false;
                }
                if (!state.is(Blocks.PISTON) && !state.is(Blocks.STICKY_PISTON)) {
                    if (state.getDestroySpeed((BlockGetter)level, pos) == -1.0f) {
                        return false;
                    }
                    switch (state.getPistonPushReaction()) {
                        case BLOCK: {
                            return false;
                        }
                        case DESTROY: {
                            return allowDestroy;
                        }
                        case PUSH_ONLY: {
                            return movementDirection == pistonFacing;
                        }
                    }
                } else if (((Boolean)state.getValue((Property)PistonBaseBlock.EXTENDED)).booleanValue()) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

