/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.client.IScreenProvider;
import net.mehvahdjukaar.supplementaries.client.screens.DoormatScreen;
import net.mehvahdjukaar.supplementaries.common.block.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.common.block.TextHolder;
import net.mehvahdjukaar.supplementaries.common.block.blocks.DoormatBlock;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DoormatBlockTile
extends ItemDisplayTile
implements ITextHolderProvider,
IScreenProvider {
    public static final int MAX_LINES = 3;
    public final TextHolder textHolder = new TextHolder(3, 75);
    @Nullable
    private UUID playerWhoMayEdit;
    private boolean isWaxed = false;

    public DoormatBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.DOORMAT_TILE.get(), pos, state);
    }

    @Override
    public TextHolder getTextHolder(int i) {
        return this.textHolder;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.textHolder.load(tag, registries, this.getBlockPos());
        if (tag.contains("Waxed")) {
            this.isWaxed = tag.getBoolean("Waxed");
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.textHolder.save(tag, registries);
        if (this.isWaxed) {
            tag.putBoolean("Waxed", this.isWaxed);
        }
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)DoormatBlock.FACING);
    }

    public void openScreen(Level level, Player player, Direction direction, Vec3 pos) {
        DoormatScreen.open(this);
    }

    public SoundEvent getAddItemSound() {
        return SoundEvents.BRUSH_GENERIC;
    }

    public void setWaxed(boolean waxed) {
        this.isWaxed = waxed;
    }

    public boolean isWaxed() {
        return this.isWaxed;
    }

    public void setCurrentUser(@Nullable UUID playerWhoMayEdit) {
        this.playerWhoMayEdit = playerWhoMayEdit;
    }

    public UUID getCurrentUser() {
        return this.playerWhoMayEdit;
    }

    public boolean canTakeItem(Container container, int i, ItemStack itemStack) {
        return false;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return false;
    }
}

