/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.input;

import dan200.computercraft.core.input.ComputerInput;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.util.StringUtil;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.ByteBuffer;

public final class UserComputerInput
implements ComputerInput {
    private final ComputerInput delegate;
    private final boolean mouseSupport;
    private final int termWidth;
    private final int termHeight;
    private final IntSet keysDown = new IntOpenHashSet(4);
    private int lastMouseX;
    private int lastMouseY;
    private int lastMouseDown = -1;

    public UserComputerInput(ComputerInput delegate, boolean mouseSupport, int termWidth, int termHeight) {
        this.delegate = delegate;
        this.mouseSupport = mouseSupport;
        this.termWidth = termWidth;
        this.termHeight = termHeight;
    }

    public UserComputerInput(ComputerInput delegate, Terminal terminal) {
        this(delegate, terminal.isColour(), terminal.getWidth(), terminal.getHeight());
    }

    @Override
    public void keyDown(int key, boolean repeat) {
        if (key < 0) {
            return;
        }
        this.keysDown.add(key);
        this.delegate.keyDown(key, repeat);
    }

    public void keyDown(int key) {
        this.keyDown(key, this.keysDown.contains(key));
    }

    @Override
    public void keyUp(int key) {
        if (key < 0) {
            return;
        }
        this.keysDown.remove(key);
        this.delegate.keyUp(key);
    }

    @Override
    public void charTyped(byte chr) {
        this.delegate.charTyped(chr);
    }

    public void codepointTyped(int codepoint) {
        int terminalChar = StringUtil.unicodeToTerminal(codepoint);
        if (StringUtil.isTypableChar(terminalChar)) {
            this.charTyped((byte)terminalChar);
        }
    }

    private static boolean isValidClipboard(ByteBuffer buffer) {
        int max = buffer.limit();
        for (int i = buffer.position(); i < max; ++i) {
            if (StringUtil.isTypableChar(buffer.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void paste(ByteBuffer contents) {
        if (contents.remaining() > 0 && UserComputerInput.isValidClipboard(contents)) {
            this.delegate.paste(contents);
        }
    }

    public void paste(String contents) {
        this.paste(StringUtil.getClipboardString(contents));
    }

    @Override
    public void mouseClick(int button, int x, int y) {
        if (!this.mouseSupport || button < 1 || button > 3) {
            return;
        }
        int clampedX = this.lastMouseX = Math.min(Math.max(x, 1), this.termWidth);
        int clampedY = this.lastMouseY = Math.min(Math.max(y, 1), this.termHeight);
        this.delegate.mouseClick(button, clampedX, clampedY);
        this.lastMouseDown = button;
    }

    public void mouseClick(int button) {
        this.mouseClick(button, this.lastMouseX, this.lastMouseY);
    }

    @Override
    public void mouseUp(int button, int x, int y) {
        if (!this.mouseSupport || button < 1 || button > 3) {
            return;
        }
        int clampedX = this.lastMouseX = Math.min(Math.max(x, 1), this.termWidth);
        int clampedY = this.lastMouseY = Math.min(Math.max(y, 1), this.termHeight);
        if (this.lastMouseDown == button) {
            this.delegate.mouseUp(button, clampedX, clampedY);
            this.lastMouseDown = -1;
        }
    }

    public void mouseUp(int button) {
        this.mouseUp(button, this.lastMouseX, this.lastMouseY);
    }

    @Override
    public void mouseDrag(int button, int x, int y) {
        if (!this.mouseSupport || button < 1 || button > 3) {
            return;
        }
        int clampedX = Math.min(Math.max(x, 1), this.termWidth);
        int clampedY = Math.min(Math.max(y, 1), this.termHeight);
        if (button == this.lastMouseDown && (clampedX != this.lastMouseX || clampedY != this.lastMouseY)) {
            this.delegate.mouseDrag(button, clampedX, clampedY);
            this.lastMouseX = clampedX;
            this.lastMouseY = clampedY;
        }
    }

    public void mouseMove(int x, int y) {
        if (!this.mouseSupport) {
            return;
        }
        int clampedX = Math.min(Math.max(x, 1), this.termWidth);
        int clampedY = Math.min(Math.max(y, 1), this.termHeight);
        if (this.lastMouseDown != -1 && (clampedX != this.lastMouseX || clampedY != this.lastMouseY)) {
            this.delegate.mouseDrag(this.lastMouseDown, clampedX, clampedY);
        }
        this.lastMouseX = clampedX;
        this.lastMouseY = clampedY;
    }

    @Override
    public void mouseScroll(int direction, int x, int y) {
        if (!this.mouseSupport || direction == 0) {
            return;
        }
        int clampedX = this.lastMouseX = Math.min(Math.max(x, 1), this.termWidth);
        int clampedY = this.lastMouseY = Math.min(Math.max(y, 1), this.termHeight);
        this.delegate.mouseScroll(direction, clampedX, clampedY);
    }

    public void mouseScroll(int direction) {
        this.mouseScroll(direction, this.lastMouseX, this.lastMouseY);
    }

    public void releaseInputs() {
        IntIterator keys = this.keysDown.iterator();
        while (keys.hasNext()) {
            this.delegate.keyUp(keys.nextInt());
        }
        this.keysDown.clear();
        if (this.lastMouseDown != -1) {
            this.delegate.mouseUp(this.lastMouseDown, this.lastMouseX, this.lastMouseY);
            this.lastMouseDown = -1;
        }
    }
}

