/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import dan200.computercraft.api.client.turtle.RegisterTurtleModellersEvent;
import dan200.computercraft.client.ClientRegistry;
import dan200.computercraft.client.model.ExtraModels;
import dan200.computercraft.client.model.turtle.TurtleModelLoader;
import dan200.computercraft.client.turtle.TurtleUpgradeModellers;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;

@EventBusSubscriber(modid="computercraft", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public final class ForgeClientRegistry {
    private static final Object lock = new Object();
    private static boolean gatheredModellers = false;

    private ForgeClientRegistry() {
    }

    @SubscribeEvent
    public static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"turtle"), (IGeometryLoader)TurtleModelLoader.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void gatherModellers() {
        if (gatheredModellers) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (gatheredModellers) {
                return;
            }
            gatheredModellers = true;
            ModLoader.postEvent((Event)new RegisterTurtleModellersEvent(TurtleUpgradeModellers::register));
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterAdditional event) {
        ForgeClientRegistry.gatherModellers();
        Collection<ResourceLocation> extraModels = ExtraModels.loadAll(Minecraft.getInstance().getResourceManager());
        ClientRegistry.registerExtraModels(x -> event.register(ModelResourceLocation.standalone((ResourceLocation)x)), extraModels);
    }

    @SubscribeEvent
    public static void registerShaders(RegisterShadersEvent event) throws IOException {
        ClientRegistry.registerShaders(event.getResourceProvider(), (arg_0, arg_1) -> ((RegisterShadersEvent)event).registerShader(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void onTurtleModellers(RegisterTurtleModellersEvent event) {
        ClientRegistry.registerTurtleModellers(event);
    }

    @SubscribeEvent
    public static void onItemColours(RegisterColorHandlersEvent.Item event) {
        ClientRegistry.registerItemColours((x$0, xva$1) -> event.register(x$0, new ItemLike[]{xva$1}));
    }

    @SubscribeEvent
    public static void registerMenuScreens(RegisterMenuScreensEvent event) {
        ClientRegistry.registerMenuScreens((arg_0, arg_1) -> ((RegisterMenuScreensEvent)event).register(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        ClientRegistry.register();
        event.enqueueWork(() -> ClientRegistry.registerMainThread(ItemProperties::register));
    }
}

