/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.vivecraft.client_vr.utils.RGBAColor;

public class ColoredButton
extends Button {
    private static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"widget/button"), ResourceLocation.withDefaultNamespace((String)"widget/button_disabled"), ResourceLocation.withDefaultNamespace((String)"widget/button_highlighted"));
    private final RGBAColor color = new RGBAColor();

    public ColoredButton(Component message, int x, int y, int width, int height, Button.OnPress onPress) {
        super(x, y, width, height, message, onPress, Button.DEFAULT_NARRATION);
    }

    public RGBAColor getColor() {
        return this.color;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.setColor(this.color.r, this.color.g, this.color.b, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        guiGraphics.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int color = this.active ? 0xFFFFFF : 0xA0A0A0;
        this.renderString(guiGraphics, Minecraft.getInstance().font, color | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }
}

