/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.lwjgl.openvr.HmdColor;
import org.lwjgl.openvr.HmdQuad;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class VRChaperone {
    protected VRChaperone() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="ChaperoneCalibrationState")
    public static int VRChaperone_GetCalibrationState() {
        long __functionAddress = OpenVR.VRChaperone.GetCalibrationState;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callI((long)__functionAddress);
    }

    public static boolean nVRChaperone_GetPlayAreaSize(long pSizeX, long pSizeZ) {
        long __functionAddress = OpenVR.VRChaperone.GetPlayAreaSize;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPZ((long)pSizeX, (long)pSizeZ, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRChaperone_GetPlayAreaSize(@NativeType(value="float *") FloatBuffer pSizeX, @NativeType(value="float *") FloatBuffer pSizeZ) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSizeX, (int)1);
            Checks.check((Buffer)pSizeZ, (int)1);
        }
        return VRChaperone.nVRChaperone_GetPlayAreaSize(MemoryUtil.memAddress((FloatBuffer)pSizeX), MemoryUtil.memAddress((FloatBuffer)pSizeZ));
    }

    public static boolean nVRChaperone_GetPlayAreaRect(long rect) {
        long __functionAddress = OpenVR.VRChaperone.GetPlayAreaRect;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPZ((long)rect, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRChaperone_GetPlayAreaRect(@NativeType(value="HmdQuad_t *") HmdQuad rect) {
        return VRChaperone.nVRChaperone_GetPlayAreaRect(rect.address());
    }

    public static void VRChaperone_ReloadInfo() {
        long __functionAddress = OpenVR.VRChaperone.ReloadInfo;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callV((long)__functionAddress);
    }

    public static native void nVRChaperone_SetSceneColor(long var0, long var2);

    public static void nVRChaperone_SetSceneColor(long color) {
        long __functionAddress = OpenVR.VRChaperone.SetSceneColor;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        VRChaperone.nVRChaperone_SetSceneColor(color, __functionAddress);
    }

    public static void VRChaperone_SetSceneColor(@NativeType(value="HmdColor_t") HmdColor color) {
        VRChaperone.nVRChaperone_SetSceneColor(color.address());
    }

    public static void nVRChaperone_GetBoundsColor(long pOutputColorArray, int nNumOutputColors, float flCollisionBoundsFadeDistance, long pOutputCameraColor) {
        long __functionAddress = OpenVR.VRChaperone.GetBoundsColor;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((long)pOutputColorArray, (int)nNumOutputColors, (float)flCollisionBoundsFadeDistance, (long)pOutputCameraColor, (long)__functionAddress);
    }

    public static void VRChaperone_GetBoundsColor(@NativeType(value="HmdColor_t *") HmdColor.Buffer pOutputColorArray, float flCollisionBoundsFadeDistance, @NativeType(value="HmdColor_t *") HmdColor pOutputCameraColor) {
        VRChaperone.nVRChaperone_GetBoundsColor(pOutputColorArray.address(), pOutputColorArray.remaining(), flCollisionBoundsFadeDistance, pOutputCameraColor.address());
    }

    @NativeType(value="bool")
    public static boolean VRChaperone_AreBoundsVisible() {
        long __functionAddress = OpenVR.VRChaperone.AreBoundsVisible;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callZ((long)__functionAddress);
    }

    public static void VRChaperone_ForceBoundsVisible(@NativeType(value="bool") boolean bForce) {
        long __functionAddress = OpenVR.VRChaperone.ForceBoundsVisible;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callV((boolean)bForce, (long)__functionAddress);
    }

    public static void VRChaperone_ResetZeroPose(@NativeType(value="ETrackingUniverseOrigin") int eTrackingUniverseOrigin) {
        long __functionAddress = OpenVR.VRChaperone.ResetZeroPose;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callV((int)eTrackingUniverseOrigin, (long)__functionAddress);
    }

    static {
        OpenVR.initialize();
    }
}

