/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdVector2_t")
public class HmdVector2
extends Struct<HmdVector2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int V;

    protected HmdVector2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected HmdVector2 create(long address, @Nullable ByteBuffer container) {
        return new HmdVector2(address, container);
    }

    public HmdVector2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), HmdVector2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[2]")
    public FloatBuffer v() {
        return HmdVector2.nv(this.address());
    }

    public float v(int index) {
        return HmdVector2.nv(this.address(), index);
    }

    public HmdVector2 v(@NativeType(value="float[2]") FloatBuffer value) {
        HmdVector2.nv(this.address(), value);
        return this;
    }

    public HmdVector2 v(int index, float value) {
        HmdVector2.nv(this.address(), index, value);
        return this;
    }

    public HmdVector2 set(HmdVector2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static HmdVector2 malloc() {
        return new HmdVector2(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static HmdVector2 calloc() {
        return new HmdVector2(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static HmdVector2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new HmdVector2(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static HmdVector2 create(long address) {
        return new HmdVector2(address, null);
    }

    @Nullable
    public static HmdVector2 createSafe(long address) {
        return address == 0L ? null : new HmdVector2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)HmdVector2.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = HmdVector2.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static HmdVector2 mallocStack() {
        return HmdVector2.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdVector2 callocStack() {
        return HmdVector2.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdVector2 mallocStack(MemoryStack stack) {
        return HmdVector2.malloc(stack);
    }

    @Deprecated
    public static HmdVector2 callocStack(MemoryStack stack) {
        return HmdVector2.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return HmdVector2.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return HmdVector2.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdVector2.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdVector2.calloc(capacity, stack);
    }

    public static HmdVector2 malloc(MemoryStack stack) {
        return new HmdVector2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static HmdVector2 calloc(MemoryStack stack) {
        return new HmdVector2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nv(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)V), (int)2);
    }

    public static float nv(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)V + Checks.check((int)index, (int)2) * 4L);
    }

    public static void nv(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((FloatBuffer)value), (long)(struct + (long)V), (long)(value.remaining() * 4));
    }

    public static void nv(long struct, int index, float value) {
        UNSAFE.putFloat(null, struct + (long)V + Checks.check((int)index, (int)2) * 4L, value);
    }

    static {
        Struct.Layout layout = HmdVector2.__struct((Struct.Member[])new Struct.Member[]{HmdVector2.__array((int)4, (int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        V = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<HmdVector2, Buffer>
    implements NativeResource {
        private static final HmdVector2 ELEMENT_FACTORY = HmdVector2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected HmdVector2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float[2]")
        public FloatBuffer v() {
            return HmdVector2.nv(this.address());
        }

        public float v(int index) {
            return HmdVector2.nv(this.address(), index);
        }

        public Buffer v(@NativeType(value="float[2]") FloatBuffer value) {
            HmdVector2.nv(this.address(), value);
            return this;
        }

        public Buffer v(int index, float value) {
            HmdVector2.nv(this.address(), index, value);
            return this;
        }
    }
}

