/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.items;

import com.github.talrey.createdeco.BlockRegistry;
import com.github.talrey.createdeco.blocks.CatwalkRailingBlock;
import com.github.talrey.createdeco.blocks.CatwalkStairBlock;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class RailingBlockItem
extends BlockItem {
    private final int placementHelperID = PlacementHelpers.register((IPlacementHelper)new RailingHelper());

    public RailingBlockItem(CatwalkRailingBlock block, Item.Properties props) {
        super((Block)block, props);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        BlockPos pos = ctx.getClickedPos();
        Direction face = ctx.getClickedFace();
        Level level = ctx.getLevel();
        Player player = ctx.getPlayer();
        ItemStack stack = ctx.getItemInHand();
        BlockState state = level.getBlockState(pos);
        IPlacementHelper helper = PlacementHelpers.get((int)this.placementHelperID);
        BlockHitResult ray = new BlockHitResult(ctx.getClickLocation(), face, pos, true);
        if (player == null) {
            return InteractionResult.PASS;
        }
        Block block = state.getBlock();
        if (block instanceof CatwalkStairBlock) {
            CatwalkStairBlock catstair = (CatwalkStairBlock)block;
            if (this.getBlock().equals(BlockRegistry.CATWALK_RAILINGS.get(catstair.metal).get())) {
                Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                double xPos = ctx.getClickLocation().x - (double)pos.getX() - 0.5;
                double zPos = ctx.getClickLocation().z - (double)pos.getZ() - 0.5;
                boolean left = false;
                if (dir == Direction.NORTH) {
                    boolean bl = left = xPos > 0.0;
                }
                if (dir == Direction.SOUTH) {
                    boolean bl = left = xPos < 0.0;
                }
                if (dir == Direction.EAST) {
                    boolean bl = left = zPos > 0.0;
                }
                if (dir == Direction.WEST) {
                    left = zPos < 0.0;
                }
                if (((Boolean)state.getValue((Property)(left ? CatwalkStairBlock.RAILING_LEFT : CatwalkStairBlock.RAILING_RIGHT))).booleanValue()) {
                    return InteractionResult.PASS;
                }
                SoundType soundType = state.getSoundType();
                level.setBlock(pos, (BlockState)state.setValue((Property)(left ? CatwalkStairBlock.RAILING_LEFT : CatwalkStairBlock.RAILING_RIGHT), (Comparable)Boolean.valueOf(true)), 3);
                level.playSound(player, pos, this.getPlaceSound(state), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
                level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        PlacementOffset offset = null;
        if (helper.matchesState(state)) {
            offset = helper.getOffset(player, level, state, pos, ray);
        }
        if (offset != null && offset.isSuccessful() && !player.isShiftKeyDown()) {
            state = offset.getGhostState();
            BlockPos offsetPos = offset.getBlockPos();
            SoundType soundType = state.getSoundType();
            level.setBlock(offsetPos, (BlockState)offset.getTransform().apply(state), 3);
            level.playSound(player, offsetPos, this.getPlaceSound(state), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
            level.gameEvent((Holder)GameEvent.BLOCK_PLACE, offsetPos, GameEvent.Context.of((Entity)player, (BlockState)state));
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(ctx);
    }

    @MethodsReturnNonnullByDefault
    public static class RailingHelper
    implements IPlacementHelper {
        public Predicate<ItemStack> getItemPredicate() {
            return CatwalkRailingBlock::isRailing;
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> true;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction face = ray.getDirection();
            BlockState adjacent = world.getBlockState(pos.relative(face));
            if (CatwalkRailingBlock.isRailing(adjacent.getBlock())) {
                pos = pos.relative(face);
                state = adjacent;
            }
            boolean railMatchTest = player.isHolding(state.getBlock().asItem());
            if (!CatwalkRailingBlock.isRailing(state.getBlock()) || ((Boolean)state.getValue((Property)CatwalkRailingBlock.NORTH_FENCE)).booleanValue() && ((Boolean)state.getValue((Property)CatwalkRailingBlock.SOUTH_FENCE)).booleanValue() && ((Boolean)state.getValue((Property)CatwalkRailingBlock.EAST_FENCE)).booleanValue() && ((Boolean)state.getValue((Property)CatwalkRailingBlock.WEST_FENCE)).booleanValue() || !railMatchTest) {
                return PlacementOffset.fail();
            }
            List dirs = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)Direction.Axis.Y);
            for (Direction offset : dirs) {
                if (((Boolean)state.getValue((Property)CatwalkRailingBlock.fromDirection(offset))).booleanValue()) continue;
                state = (BlockState)state.setValue((Property)CatwalkRailingBlock.fromDirection(offset), (Comparable)Boolean.valueOf(true));
                break;
            }
            BlockState finalState = state;
            return PlacementOffset.success((Vec3i)pos, newState -> finalState).withGhostState(finalState);
        }
    }
}

