/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.blocks;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SupportWedgeBlock
extends Block
implements IWrenchable,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING;
    public static final IntegerProperty ORIENTATION;
    public static final BooleanProperty WATERLOGGED;
    protected static final VoxelShape NORTH_1_AABB;
    protected static final VoxelShape SOUTH_1_AABB;
    protected static final VoxelShape EAST_1_AABB;
    protected static final VoxelShape WEST_1_AABB;
    protected static final VoxelShape NORTH_2_AABB;
    protected static final VoxelShape SOUTH_2_AABB;
    protected static final VoxelShape EAST_2_AABB;
    protected static final VoxelShape WEST_2_AABB;
    protected static final VoxelShape NORTH_3_AABB;
    protected static final VoxelShape SOUTH_3_AABB;
    protected static final VoxelShape EAST_3_AABB;
    protected static final VoxelShape WEST_3_AABB;
    protected static final VoxelShape NORTH_4_AABB;
    protected static final VoxelShape SOUTH_4_AABB;
    protected static final VoxelShape EAST_4_AABB;
    protected static final VoxelShape WEST_4_AABB;

    public SupportWedgeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ORIENTATION, (Comparable)Integer.valueOf(1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, FACING, ORIENTATION});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.getValue((Property)FACING) == Direction.NORTH) {
            return switch ((Integer)state.getValue((Property)ORIENTATION)) {
                default -> NORTH_1_AABB;
                case 2 -> NORTH_2_AABB;
                case 3 -> NORTH_3_AABB;
                case 4 -> NORTH_4_AABB;
            };
        }
        if (state.getValue((Property)FACING) == Direction.SOUTH) {
            return switch ((Integer)state.getValue((Property)ORIENTATION)) {
                default -> SOUTH_1_AABB;
                case 2 -> SOUTH_2_AABB;
                case 3 -> SOUTH_3_AABB;
                case 4 -> SOUTH_4_AABB;
            };
        }
        if (state.getValue((Property)FACING) == Direction.EAST) {
            return switch ((Integer)state.getValue((Property)ORIENTATION)) {
                default -> EAST_1_AABB;
                case 2 -> EAST_2_AABB;
                case 3 -> EAST_3_AABB;
                case 4 -> EAST_4_AABB;
            };
        }
        if (state.getValue((Property)FACING) == Direction.WEST) {
            return switch ((Integer)state.getValue((Property)ORIENTATION)) {
                default -> WEST_1_AABB;
                case 2 -> WEST_2_AABB;
                case 3 -> WEST_3_AABB;
                case 4 -> WEST_4_AABB;
            };
        }
        return NORTH_1_AABB;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction[] var6;
        BlockState blockState;
        if (!context.replacingClickedOnBlock() && (blockState = context.getLevel().getBlockState(context.getClickedPos().relative(context.getClickedFace().getOpposite()))).is((Block)this) && blockState.getValue((Property)FACING) == context.getClickedFace()) {
            return null;
        }
        blockState = this.defaultBlockState();
        Level levelReader = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        for (Direction direction : var6 = context.getNearestLookingDirections()) {
            boolean topleft;
            boolean bottomleft;
            if (!direction.getAxis().isHorizontal()) continue;
            int location = 1;
            double xPos = context.getClickLocation().x - (double)blockPos.getX() - 0.5;
            double yPos = context.getClickLocation().y - (double)blockPos.getY() - 0.5;
            double zPos = context.getClickLocation().z - (double)blockPos.getZ() - 0.5;
            if (context.getClickedFace() == Direction.NORTH || context.getClickedFace() == Direction.SOUTH) {
                bottomleft = xPos < -yPos;
                boolean bl = topleft = xPos < yPos;
                if (!bottomleft && topleft) {
                    location = 1;
                }
                if (!bottomleft && !topleft) {
                    location = 2;
                }
                if (bottomleft && !topleft) {
                    location = 3;
                }
                if (bottomleft && topleft) {
                    location = 4;
                }
            }
            if (context.getClickedFace() == Direction.EAST || context.getClickedFace() == Direction.WEST) {
                bottomleft = zPos < -yPos;
                boolean bl = topleft = zPos < yPos;
                if (!bottomleft && topleft) {
                    location = 1;
                }
                if (!bottomleft && !topleft) {
                    location = 2;
                }
                if (bottomleft && !topleft) {
                    location = 3;
                }
                if (bottomleft && topleft) {
                    location = 4;
                }
            }
            if (context.getClickedFace() == Direction.UP) {
                location = 3;
            }
            if (!(blockState = (BlockState)((BlockState)blockState.setValue((Property)FACING, (Comparable)direction.getOpposite())).setValue((Property)ORIENTATION, (Comparable)Integer.valueOf(location))).canSurvive((LevelReader)levelReader, blockPos)) continue;
            return (BlockState)blockState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        }
        return null;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    static {
        ORIENTATION = IntegerProperty.create((String)"orientation", (int)1, (int)4);
        FACING = HorizontalDirectionalBlock.FACING;
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
        NORTH_1_AABB = Shapes.or((VoxelShape)Block.box((double)5.0, (double)8.0, (double)14.0, (double)11.0, (double)14.0, (double)16.0), (VoxelShape)Block.box((double)5.0, (double)14.0, (double)8.0, (double)11.0, (double)16.0, (double)16.0));
        NORTH_2_AABB = Shapes.or((VoxelShape)Block.box((double)8.0, (double)5.0, (double)14.0, (double)14.0, (double)11.0, (double)16.0), (VoxelShape)Block.box((double)14.0, (double)5.0, (double)8.0, (double)16.0, (double)11.0, (double)16.0));
        NORTH_3_AABB = Shapes.or((VoxelShape)Block.box((double)5.0, (double)2.0, (double)14.0, (double)11.0, (double)8.0, (double)16.0), (VoxelShape)Block.box((double)5.0, (double)0.0, (double)8.0, (double)11.0, (double)2.0, (double)16.0));
        NORTH_4_AABB = Shapes.or((VoxelShape)Block.box((double)2.0, (double)5.0, (double)14.0, (double)8.0, (double)11.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)5.0, (double)8.0, (double)2.0, (double)11.0, (double)16.0));
        SOUTH_1_AABB = Shapes.or((VoxelShape)Block.box((double)5.0, (double)8.0, (double)0.0, (double)11.0, (double)14.0, (double)2.0), (VoxelShape)Block.box((double)5.0, (double)14.0, (double)0.0, (double)11.0, (double)16.0, (double)8.0));
        SOUTH_2_AABB = Shapes.or((VoxelShape)Block.box((double)8.0, (double)5.0, (double)0.0, (double)14.0, (double)11.0, (double)2.0), (VoxelShape)Block.box((double)14.0, (double)5.0, (double)0.0, (double)16.0, (double)11.0, (double)8.0));
        SOUTH_3_AABB = Shapes.or((VoxelShape)Block.box((double)5.0, (double)2.0, (double)0.0, (double)11.0, (double)8.0, (double)2.0), (VoxelShape)Block.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)2.0, (double)8.0));
        SOUTH_4_AABB = Shapes.or((VoxelShape)Block.box((double)2.0, (double)5.0, (double)0.0, (double)8.0, (double)11.0, (double)2.0), (VoxelShape)Block.box((double)0.0, (double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)8.0));
        EAST_1_AABB = Shapes.or((VoxelShape)Block.box((double)0.0, (double)8.0, (double)5.0, (double)2.0, (double)14.0, (double)11.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)5.0, (double)8.0, (double)16.0, (double)11.0));
        EAST_2_AABB = Shapes.or((VoxelShape)Block.box((double)0.0, (double)5.0, (double)8.0, (double)2.0, (double)11.0, (double)14.0), (VoxelShape)Block.box((double)0.0, (double)5.0, (double)14.0, (double)8.0, (double)11.0, (double)16.0));
        EAST_3_AABB = Shapes.or((VoxelShape)Block.box((double)0.0, (double)2.0, (double)5.0, (double)2.0, (double)8.0, (double)11.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)5.0, (double)8.0, (double)2.0, (double)11.0));
        EAST_4_AABB = Shapes.or((VoxelShape)Block.box((double)0.0, (double)5.0, (double)2.0, (double)2.0, (double)11.0, (double)8.0), (VoxelShape)Block.box((double)0.0, (double)5.0, (double)0.0, (double)8.0, (double)11.0, (double)2.0));
        WEST_1_AABB = Shapes.or((VoxelShape)Block.box((double)14.0, (double)8.0, (double)5.0, (double)16.0, (double)14.0, (double)11.0), (VoxelShape)Block.box((double)8.0, (double)14.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0));
        WEST_2_AABB = Shapes.or((VoxelShape)Block.box((double)14.0, (double)5.0, (double)8.0, (double)16.0, (double)11.0, (double)14.0), (VoxelShape)Block.box((double)8.0, (double)5.0, (double)14.0, (double)16.0, (double)11.0, (double)16.0));
        WEST_3_AABB = Shapes.or((VoxelShape)Block.box((double)14.0, (double)2.0, (double)5.0, (double)16.0, (double)8.0, (double)11.0), (VoxelShape)Block.box((double)8.0, (double)0.0, (double)5.0, (double)16.0, (double)2.0, (double)11.0));
        WEST_4_AABB = Shapes.or((VoxelShape)Block.box((double)14.0, (double)5.0, (double)2.0, (double)16.0, (double)11.0, (double)8.0), (VoxelShape)Block.box((double)8.0, (double)5.0, (double)0.0, (double)16.0, (double)11.0, (double)2.0));
    }
}

