/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiLevelType;
import com.seibel.distanthorizons.api.interfaces.render.IDhApiCustomRenderRegister;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.level.IKeyedClientLevelManager;
import com.seibel.distanthorizons.core.level.IServerKeyedClientLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.ClientBlockStateColorCache;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.DimensionTypeWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientLevelWrapper
implements IClientLevelWrapper {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final Map<ClientLevel, WeakReference<ClientLevelWrapper>> LEVEL_WRAPPER_REF_BY_CLIENT_LEVEL = Collections.synchronizedMap(new WeakHashMap());
    private static final IKeyedClientLevelManager KEYED_CLIENT_LEVEL_MANAGER = SingletonInjector.INSTANCE.get(IKeyedClientLevelManager.class);
    private static final Minecraft MINECRAFT = Minecraft.getInstance();
    private final ClientLevel level;
    private final ConcurrentHashMap<BlockState, ClientBlockStateColorCache> blockColorCacheByBlockState = new ConcurrentHashMap();
    private final Function<BlockState, ClientBlockStateColorCache> createCachedBlockColorCacheFunc = blockState -> new ClientBlockStateColorCache((BlockState)blockState, this);
    private BlockStateWrapper dirtBlockWrapper;
    private IDhLevel dhLevel;

    protected ClientLevelWrapper(ClientLevel level) {
        this.level = level;
    }

    @Nullable
    public static IClientLevelWrapper getWrapperIfDifferent(@Nullable IClientLevelWrapper levelWrapper, @NotNull ClientLevel level) {
        if (KEYED_CLIENT_LEVEL_MANAGER.isEnabled() && KEYED_CLIENT_LEVEL_MANAGER.getServerKeyedLevel() != levelWrapper) {
            return ClientLevelWrapper.getWrapper(level);
        }
        ClientLevelWrapper clientLevelWrapper = (ClientLevelWrapper)levelWrapper;
        if (clientLevelWrapper == null || clientLevelWrapper.level != level) {
            return ClientLevelWrapper.getWrapper(level);
        }
        return clientLevelWrapper;
    }

    @Nullable
    public static IClientLevelWrapper getWrapper(@NotNull ClientLevel level) {
        return ClientLevelWrapper.getWrapper(level, false);
    }

    @Nullable
    public static IClientLevelWrapper getWrapper(@Nullable ClientLevel level, boolean bypassLevelKeyManager) {
        ClientLevelWrapper levelWrapper;
        WeakReference<ClientLevelWrapper> levelRef;
        if (!bypassLevelKeyManager) {
            if (level == null) {
                return null;
            }
            IServerKeyedClientLevel overrideLevel = KEYED_CLIENT_LEVEL_MANAGER.getServerKeyedLevel();
            if (overrideLevel != null) {
                return overrideLevel;
            }
        }
        if ((levelRef = LEVEL_WRAPPER_REF_BY_CLIENT_LEVEL.get(level)) != null && (levelWrapper = (ClientLevelWrapper)levelRef.get()) != null) {
            return levelWrapper;
        }
        return (IClientLevelWrapper)LEVEL_WRAPPER_REF_BY_CLIENT_LEVEL.compute(level, (newLevel, newLevelRef) -> {
            ClientLevelWrapper oldLevelWrapper;
            if (newLevelRef != null && (oldLevelWrapper = (ClientLevelWrapper)newLevelRef.get()) != null) {
                return newLevelRef;
            }
            return new WeakReference<ClientLevelWrapper>(new ClientLevelWrapper((ClientLevel)newLevel));
        }).get();
    }

    @Override
    @Nullable
    public IServerLevelWrapper tryGetServerSideWrapper() {
        try {
            if (MINECRAFT.getSingleplayerServer() == null) {
                return null;
            }
            Iterable serverLevels = MINECRAFT.getSingleplayerServer().getAllLevels();
            ServerLevelWrapper foundLevelWrapper = null;
            for (ServerLevel serverLevel : serverLevels) {
                if (serverLevel.dimension() != this.level.dimension()) continue;
                foundLevelWrapper = ServerLevelWrapper.getWrapper(serverLevel);
                break;
            }
            return foundLevelWrapper;
        }
        catch (Exception e) {
            LOGGER.error("Failed to get server side wrapper for client level: " + String.valueOf(this.level), new Object[0]);
            return null;
        }
    }

    @Override
    public int getBlockColor(DhBlockPos blockPos, IBiomeWrapper biome, FullDataSourceV2 fullDataSource, IBlockStateWrapper blockWrapper) {
        ClientBlockStateColorCache blockColorCache = this.blockColorCacheByBlockState.get(((BlockStateWrapper)blockWrapper).blockState);
        if (blockColorCache == null) {
            blockColorCache = this.blockColorCacheByBlockState.computeIfAbsent(((BlockStateWrapper)blockWrapper).blockState, this.createCachedBlockColorCacheFunc);
        }
        return blockColorCache.getColor((BiomeWrapper)biome, fullDataSource, blockPos);
    }

    @Override
    public int getDirtBlockColor() {
        if (this.dirtBlockWrapper == null) {
            try {
                this.dirtBlockWrapper = (BlockStateWrapper)BlockStateWrapper.deserialize("minecraft:dirt", this);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to get dirt color with resource location [minecraft:dirt] with level [" + String.valueOf(this) + "].", e);
                return -1;
            }
        }
        return this.getBlockColor(DhBlockPos.ZERO, BiomeWrapper.EMPTY_WRAPPER, null, this.dirtBlockWrapper);
    }

    @Override
    public void clearBlockColorCache() {
        this.blockColorCacheByBlockState.clear();
    }

    @Override
    public IDimensionTypeWrapper getDimensionType() {
        return DimensionTypeWrapper.getDimensionTypeWrapper(this.level.dimensionType());
    }

    @Override
    public String getDimensionName() {
        return this.level.dimension().location().toString();
    }

    @Override
    public long getHashedSeed() {
        return this.level.getBiomeManager().biomeZoomSeed;
    }

    @Override
    public String getDhIdentifier() {
        return this.getHashedSeedEncoded() + "@" + this.getDimensionName();
    }

    @Override
    public EDhApiLevelType getLevelType() {
        return EDhApiLevelType.CLIENT_LEVEL;
    }

    public ClientLevel getLevel() {
        return this.level;
    }

    @Override
    public boolean hasCeiling() {
        return this.level.dimensionType().hasCeiling();
    }

    @Override
    public boolean hasSkyLight() {
        return this.level.dimensionType().hasSkyLight();
    }

    @Override
    public int getMaxHeight() {
        return this.level.getHeight();
    }

    @Override
    public int getMinHeight() {
        return this.level.getMinBuildHeight();
    }

    public ClientLevel getWrappedMcObject() {
        return this.level;
    }

    @Override
    public void onUnload() {
        LEVEL_WRAPPER_REF_BY_CLIENT_LEVEL.remove(this.level);
        this.dhLevel = null;
    }

    @Override
    public File getDhSaveFolder() {
        if (this.dhLevel == null) {
            return null;
        }
        return this.dhLevel.getSaveStructure().getSaveFolder(this);
    }

    @Override
    public void setDhLevel(IDhLevel dhLevel) {
        this.dhLevel = dhLevel;
    }

    @Override
    public IDhLevel getDhLevel() {
        return this.dhLevel;
    }

    @Override
    public IDhApiCustomRenderRegister getRenderRegister() {
        if (this.dhLevel == null) {
            return null;
        }
        return this.dhLevel.getGenericRenderer();
    }

    @Override
    public Color getCloudColor(float tickDelta) {
        Vec3 colorVec3 = this.level.getCloudColor(tickDelta);
        return new Color((float)colorVec3.x, (float)colorVec3.y, (float)colorVec3.z);
    }

    public String toString() {
        if (this.level == null) {
            return "Wrapped{null}";
        }
        return "Wrapped{" + this.level.toString() + "@" + this.getDhIdentifier() + "}";
    }
}

