/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.world;

import com.seibel.distanthorizons.core.file.structure.LocalSaveStructure;
import com.seibel.distanthorizons.core.level.AbstractDhServerLevel;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.multiplayer.server.ServerPlayerState;
import com.seibel.distanthorizons.core.multiplayer.server.ServerPlayerStateManager;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.world.IDhServerWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IServerPlayerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDhServerWorld<TDhServerLevel extends AbstractDhServerLevel>
extends AbstractDhWorld
implements IDhServerWorld {
    protected final ConcurrentHashMap<ILevelWrapper, TDhServerLevel> dhLevelByLevelWrapper = new ConcurrentHashMap();
    public final LocalSaveStructure saveStructure = new LocalSaveStructure();
    private final ServerPlayerStateManager serverPlayerStateManager = new ServerPlayerStateManager();

    public AbstractDhServerWorld(EWorldEnvironment worldEnvironment) {
        super(worldEnvironment);
    }

    @Override
    public ServerPlayerStateManager getServerPlayerStateManager() {
        return this.serverPlayerStateManager;
    }

    @Override
    public void addPlayer(IServerPlayerWrapper serverPlayer) {
        ServerPlayerState playerState = this.serverPlayerStateManager.registerJoinedPlayer(serverPlayer);
        AbstractDhServerLevel serverLevel = (AbstractDhServerLevel)this.getOrLoadServerLevel(serverPlayer.getLevel());
        if (serverLevel == null) {
            return;
        }
        serverLevel.addPlayer(serverPlayer);
        Iterator it = this.dhLevelByLevelWrapper.values().stream().distinct().iterator();
        while (it.hasNext()) {
            AbstractDhServerLevel level = (AbstractDhServerLevel)it.next();
            level.registerNetworkHandlers(playerState);
        }
        this.serverPlayerStateManager.handlePluginMessagesFromQueue(playerState);
    }

    @Override
    public void removePlayer(IServerPlayerWrapper serverPlayer) {
        IServerLevelWrapper playerLevel = serverPlayer.getLevel();
        if (playerLevel == null) {
            return;
        }
        IDhLevel serverLevel = this.getLevel(playerLevel);
        if (serverLevel == null) {
            return;
        }
        ((AbstractDhServerLevel)serverLevel).removePlayer(serverPlayer);
        this.serverPlayerStateManager.unregisterLeftPlayer(serverPlayer);
    }

    @Override
    public void changePlayerLevel(IServerPlayerWrapper player, IServerLevelWrapper originLevel, IServerLevelWrapper destinationLevel) {
        ((AbstractDhServerLevel)this.getLevel(destinationLevel)).addPlayer(player);
        ((AbstractDhServerLevel)this.getLevel(originLevel)).removePlayer(player);
    }

    public TDhServerLevel getLevel(@NotNull ILevelWrapper wrapper) {
        return (TDhServerLevel)((AbstractDhServerLevel)this.dhLevelByLevelWrapper.get(wrapper));
    }

    @Override
    public Iterable<? extends IDhLevel> getAllLoadedLevels() {
        return new HashSet<TDhServerLevel>(this.dhLevelByLevelWrapper.values());
    }

    @Override
    public int getLoadedLevelCount() {
        return this.dhLevelByLevelWrapper.size();
    }

    @Override
    public void close() {
        ArrayList closeFutures = new ArrayList();
        for (AbstractDhServerLevel abstractDhServerLevel : this.dhLevelByLevelWrapper.values()) {
            IServerLevelWrapper serverLevelWrapper = abstractDhServerLevel.getServerLevelWrapper();
            if (serverLevelWrapper != null) {
                serverLevelWrapper.onUnload();
            }
            CompletableFuture closeFuture = new CompletableFuture();
            Thread closeThread = new Thread(() -> {
                level.close();
                closeFuture.complete(null);
            }, "level shutdown");
            closeThread.start();
            closeFutures.add(closeFuture);
        }
        for (CompletableFuture completableFuture : closeFutures) {
            completableFuture.join();
        }
        this.dhLevelByLevelWrapper.clear();
        LOGGER.info("Closed DhWorld of type [" + (Object)((Object)this.environment) + "].", new Object[0]);
    }
}

