/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer.generic;

import com.seibel.distanthorizons.api.enums.rendering.EDhApiBlockMaterial;
import com.seibel.distanthorizons.api.interfaces.render.IDhApiRenderableBoxGroup;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.api.objects.math.DhApiVec3d;
import com.seibel.distanthorizons.api.objects.render.DhApiRenderableBox;
import com.seibel.distanthorizons.api.objects.render.DhApiRenderableBoxGroupShading;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericRenderObjectFactory;
import com.seibel.distanthorizons.core.sql.dto.BeaconBeamDTO;
import com.seibel.distanthorizons.core.util.RenderUtil;
import com.seibel.distanthorizons.core.util.math.Vec3d;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class BeaconRenderHandler {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final int MAX_CULLING_FREQUENCY_IN_MS = 1000;
    private final ReentrantLock updateLock = new ReentrantLock();
    private final IDhApiRenderableBoxGroup beaconBoxGroup;
    private final ArrayList<DhApiRenderableBox> fullBeaconBoxList = new ArrayList();
    private final HashSet<DhBlockPos> beaconBlockPosSet = new HashSet();
    private boolean cullingThreadRunning = false;
    private boolean updateRenderDataNextFrame = false;

    public BeaconRenderHandler(@NotNull GenericObjectRenderer renderer) {
        this.beaconBoxGroup = GenericRenderObjectFactory.INSTANCE.createAbsolutePositionedGroup("DistantHorizons:Beacons", new ArrayList<DhApiRenderableBox>(0));
        this.beaconBoxGroup.setBlockLight(15);
        this.beaconBoxGroup.setSkyLight(15);
        this.beaconBoxGroup.setSsaoEnabled(false);
        this.beaconBoxGroup.setShading(DhApiRenderableBoxGroupShading.getUnshaded());
        this.beaconBoxGroup.setPreRenderFunc(this::beforeRender);
        renderer.add(this.beaconBoxGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRenderingBeacon(BeaconBeamDTO beacon) {
        try {
            this.updateLock.lock();
            if (this.beaconBlockPosSet.add(beacon.blockPos)) {
                int maxBeaconBeamHeight = Config.Client.Advanced.Graphics.GenericRendering.beaconRenderHeight.get();
                DhApiRenderableBox beaconBox = new DhApiRenderableBox(new DhApiVec3d(beacon.blockPos.getX(), beacon.blockPos.getY() + 1, beacon.blockPos.getZ()), new DhApiVec3d(beacon.blockPos.getX() + 1, maxBeaconBeamHeight, beacon.blockPos.getZ() + 1), beacon.color, EDhApiBlockMaterial.ILLUMINATED);
                this.beaconBoxGroup.add(beaconBox);
                this.fullBeaconBoxList.add(beaconBox);
                this.beaconBoxGroup.triggerBoxChange();
            }
        }
        finally {
            this.updateLock.unlock();
        }
    }

    public void stopRenderingBeaconAtPos(DhBlockPos beaconPos) {
        try {
            this.updateLock.lock();
            if (this.beaconBlockPosSet.remove(beaconPos)) {
                Predicate<DhApiRenderableBox> removePredicate = box -> box.minPos.x == (double)beaconPos.getX() && box.minPos.y == (double)(beaconPos.getY() + 1) && box.minPos.z == (double)beaconPos.getZ();
                this.beaconBoxGroup.removeIf(removePredicate);
                this.fullBeaconBoxList.removeIf(removePredicate);
                this.beaconBoxGroup.triggerBoxChange();
            }
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBeaconColor(BeaconBeamDTO newBeam) {
        try {
            this.updateLock.lock();
            DhBlockPos pos = newBeam.blockPos;
            for (int i = 0; i < this.fullBeaconBoxList.size(); ++i) {
                DhApiRenderableBox box = this.fullBeaconBoxList.get(i);
                if (box.minPos.x != (double)pos.getX() || box.minPos.y != (double)(pos.getY() + 1) || box.minPos.z != (double)pos.getZ()) continue;
                box.color = newBeam.color;
                this.beaconBoxGroup.triggerBoxChange();
                break;
            }
        }
        finally {
            this.updateLock.unlock();
        }
    }

    private void beforeRender(DhApiRenderParam renderEventParam) {
        if (Config.Client.Advanced.Graphics.Culling.disableBeaconDistanceCulling.get().booleanValue()) {
            this.tryUpdateBeaconCullingAsync();
        }
        if (this.updateRenderDataNextFrame) {
            this.beaconBoxGroup.triggerBoxChange();
            this.updateRenderDataNextFrame = false;
        }
        this.beaconBoxGroup.setActive(Config.Client.Advanced.Graphics.GenericRendering.enableBeaconRendering.get());
    }

    private void tryUpdateBeaconCullingAsync() {
        ThreadPoolExecutor executor = ThreadPoolUtil.getBeaconCullingExecutor();
        if (executor != null && !this.cullingThreadRunning) {
            this.cullingThreadRunning = true;
            try {
                executor.execute(() -> {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        this.updateLock.lock();
                        Vec3d cameraPos = MC_RENDER.getCameraExactPosition();
                        double mcRenderDistance = MC_RENDER.getRenderDistance() * 16;
                        mcRenderDistance *= (double)RenderUtil.getAutoOverdrawPrevention();
                        this.beaconBoxGroup.clear();
                        for (DhApiRenderableBox box : this.fullBeaconBoxList) {
                            double distance = Vec3d.getHorizontalDistance(cameraPos, box.minPos);
                            if (!(distance > mcRenderDistance)) continue;
                            this.beaconBoxGroup.add(box);
                        }
                        this.updateRenderDataNextFrame = true;
                    }
                    catch (Exception e) {
                        LOGGER.error("Unexpected issue while updating beacon culling. Error: " + e.getMessage(), e);
                    }
                    finally {
                        this.updateLock.unlock();
                        this.cullingThreadRunning = false;
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }
}

