/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding;

import com.seibel.distanthorizons.api.enums.rendering.EDhApiBlockMaterial;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiDebugRendering;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderSource;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnBox;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.LodBufferContainer;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.LodQuadBuilder;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnArrayView;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListCheckout;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListPool;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.RenderDataPointUtil;
import java.util.concurrent.CompletableFuture;

public class ColumnRenderBufferBuilder {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    public static final PhantomArrayListPool ARRAY_LIST_POOL = new PhantomArrayListPool("Column Buffer Builder");

    public static CompletableFuture<LodBufferContainer> uploadBuffersAsync(IDhClientLevel clientLevel, long pos, LodQuadBuilder quadBuilder) {
        DhBlockPos minBlockPos = new DhBlockPos(DhSectionPos.getMinCornerBlockX(pos), clientLevel.getLevelWrapper().getMinHeight(), DhSectionPos.getMinCornerBlockZ(pos));
        LodBufferContainer bufferContainer = new LodBufferContainer(pos, minBlockPos);
        CompletableFuture<LodBufferContainer> uploadFuture = bufferContainer.makeAndUploadBuffersAsync(quadBuilder);
        uploadFuture.whenComplete((uploadedBuffer, exception) -> {
            if (uploadedBuffer != null && !uploadedBuffer.buffersUploaded) {
                uploadedBuffer.close();
            }
        });
        return uploadFuture;
    }

    public static void makeLodRenderData(LodQuadBuilder quadBuilder, ColumnRenderSource renderSource, IDhClientLevel clientLevel, ColumnRenderSource[] adjRegions, boolean[] isSameDetailLevel) {
        boolean columnBuilderDebugEnabled = Config.Client.Advanced.Debugging.ColumnBuilderDebugging.columnBuilderDebugEnable.get();
        if (columnBuilderDebugEnabled) {
            if (DhSectionPos.getDetailLevel(renderSource.pos) == Config.Client.Advanced.Debugging.ColumnBuilderDebugging.columnBuilderDebugDetailLevel.get() && DhSectionPos.getX(renderSource.pos) == Config.Client.Advanced.Debugging.ColumnBuilderDebugging.columnBuilderDebugXPos.get() && DhSectionPos.getZ(renderSource.pos) == Config.Client.Advanced.Debugging.ColumnBuilderDebugging.columnBuilderDebugZPos.get()) {
                boolean bl = false;
            } else {
                return;
            }
        }
        try (PhantomArrayListCheckout phantomArrayCheckout = ARRAY_LIST_POOL.checkoutArrays(0, 0, 2);){
            byte thisDetailLevel = renderSource.getDataDetailLevel();
            for (int relX = 0; relX < 64; ++relX) {
                block8: for (int relZ = 0; relZ < 64; ++relZ) {
                    int wantedZ;
                    int wantedX;
                    ColumnArrayView columnRenderData = renderSource.getVerticalDataPointView(relX, relZ);
                    if (columnRenderData.size() == 0 || !RenderDataPointUtil.doesDataPointExist(columnRenderData.get(0)) || RenderDataPointUtil.hasZeroHeight(columnRenderData.get(0)) || columnBuilderDebugEnabled && ((wantedX = Config.Client.Advanced.Debugging.ColumnBuilderDebugging.columnBuilderDebugXRow.get().intValue()) >= 0 && relX != wantedX || (wantedZ = Config.Client.Advanced.Debugging.ColumnBuilderDebugging.columnBuilderDebugZRow.get().intValue()) >= 0 && relZ != wantedZ)) continue;
                    ColumnArrayView[] adjColumnViews = new ColumnArrayView[EDhDirection.CARDINAL_COMPASS.length];
                    for (EDhDirection direction : EDhDirection.CARDINAL_COMPASS) {
                        try {
                            boolean expectedDetailLevels;
                            byte adjDetailLevel;
                            ColumnRenderSource adjRenderSource;
                            boolean isCrossRenderSourceBoundary;
                            int xAdj = relX + direction.normal.x;
                            int zAdj = relZ + direction.normal.z;
                            boolean bl = isCrossRenderSourceBoundary = xAdj < 0 || xAdj >= 64 || zAdj < 0 || zAdj >= 64;
                            if (!isCrossRenderSourceBoundary) {
                                adjRenderSource = renderSource;
                                adjDetailLevel = thisDetailLevel;
                            } else {
                                adjRenderSource = adjRegions[direction.compassIndex];
                                if (adjRenderSource == null) continue;
                                adjDetailLevel = adjRenderSource.getDataDetailLevel();
                                if (adjDetailLevel == thisDetailLevel) {
                                    if (xAdj < 0) {
                                        xAdj += 64;
                                    }
                                    if (xAdj >= 64) {
                                        xAdj -= 64;
                                    }
                                    if (zAdj < 0) {
                                        zAdj += 64;
                                    }
                                    if (zAdj >= 64) {
                                        zAdj -= 64;
                                    }
                                }
                            }
                            boolean bl2 = expectedDetailLevels = adjDetailLevel == thisDetailLevel || adjDetailLevel > thisDetailLevel;
                            if (!expectedDetailLevels) {
                                LodUtil.assertNotReach("Mismatch between adjacent detail level [" + adjDetailLevel + "] and this render source's detail level [" + thisDetailLevel + "]. Detail levels should be adj >= this.");
                            }
                            adjColumnViews[direction.compassIndex] = adjRenderSource.getVerticalDataPointView(xAdj, zAdj);
                        }
                        catch (RuntimeException e) {
                            LOGGER.warn("Failed to get adj data for relative pos: [" + thisDetailLevel + ":" + relX + "," + relZ + "] at [" + (Object)((Object)direction) + "], Error: [" + e.getMessage() + "].", e);
                        }
                    }
                    ColumnRenderSource.DebugSourceFlag debugSourceFlag = renderSource.debugGetFlag(relX, relZ);
                    for (int i = 0; i < columnRenderData.size(); ++i) {
                        int wantedColumnIndex;
                        if (Config.Client.Advanced.Debugging.ColumnBuilderDebugging.columnBuilderDebugEnable.get().booleanValue() && (wantedColumnIndex = Config.Client.Advanced.Debugging.ColumnBuilderDebugging.columnBuilderDebugColumnIndex.get().intValue()) >= 0 && i != wantedColumnIndex) continue;
                        long data = columnRenderData.get(i);
                        if (RenderDataPointUtil.hasZeroHeight(data) || !RenderDataPointUtil.doesDataPointExist(data)) continue block8;
                        long topDataPoint = i - 1 >= 0 ? columnRenderData.get(i - 1) : 0L;
                        long bottomDataPoint = i + 1 < columnRenderData.size() ? columnRenderData.get(i + 1) : 0L;
                        ColumnRenderBufferBuilder.addRenderDataPointToBuilder(clientLevel, phantomArrayCheckout, data, topDataPoint, bottomDataPoint, adjColumnViews, isSameDetailLevel, thisDetailLevel, relX, relZ, quadBuilder, debugSourceFlag);
                    }
                }
            }
        }
        quadBuilder.mergeQuads();
    }

    private static void addRenderDataPointToBuilder(IDhClientLevel clientLevel, PhantomArrayListCheckout phantomArrayCheckout, long renderData, long topRenderData, long bottomRenderData, ColumnArrayView[] adjColumnViews, boolean[] isSameDetailLevel, byte detailLevel, int renderSourceOffsetPosX, int renderSourceOffsetPosZ, LodQuadBuilder quadBuilder, ColumnRenderSource.DebugSourceFlag debugSource) {
        int color;
        long sectionPos = DhSectionPos.encode(detailLevel, renderSourceOffsetPosX, renderSourceOffsetPosZ);
        short blockWidth = (short)DhSectionPos.getDetailLevelWidthInBlocks(detailLevel);
        short blockMinX = (short)DhSectionPos.getMinCornerBlockX(sectionPos);
        short blockMinY = RenderDataPointUtil.getYMin(renderData);
        short blockMinZ = (short)DhSectionPos.getMinCornerBlockZ(sectionPos);
        short blockMaxY = (short)(RenderDataPointUtil.getYMax(renderData) - blockMinY);
        if (blockMaxY == 0) {
            return;
        }
        if (blockMaxY < 0) {
            throw new IllegalArgumentException("Negative y size for the renderDataPoint! Data: [" + RenderDataPointUtil.toString(renderData) + "].");
        }
        byte blockMaterialId = RenderDataPointUtil.getBlockMaterialId(renderData);
        boolean fullBright = false;
        EDhApiDebugRendering debugging = Config.Client.Advanced.Debugging.debugRendering.get();
        switch (debugging) {
            case OFF: {
                float saturationMultiplier = Config.Client.Advanced.Graphics.Quality.saturationMultiplier.get().floatValue();
                float brightnessMultiplier = Config.Client.Advanced.Graphics.Quality.brightnessMultiplier.get().floatValue();
                if ((double)saturationMultiplier == 1.0 && (double)brightnessMultiplier == 1.0) {
                    color = RenderDataPointUtil.getColor(renderData);
                    break;
                }
                float[] ahsv = ColorUtil.argbToAhsv(RenderDataPointUtil.getColor(renderData));
                color = ColorUtil.ahsvToArgb(ahsv[0], ahsv[1], ahsv[2] * saturationMultiplier, ahsv[3] * brightnessMultiplier);
                break;
            }
            case SHOW_DETAIL: {
                color = LodUtil.DEBUG_DETAIL_LEVEL_COLORS[detailLevel];
                fullBright = true;
                break;
            }
            case SHOW_BLOCK_MATERIAL: {
                switch (EDhApiBlockMaterial.getFromIndex(blockMaterialId)) {
                    case UNKNOWN: 
                    case AIR: {
                        color = ColorUtil.HOT_PINK;
                        break;
                    }
                    case LEAVES: {
                        color = ColorUtil.DARK_GREEN;
                        break;
                    }
                    case STONE: {
                        color = ColorUtil.GRAY;
                        break;
                    }
                    case WOOD: {
                        color = ColorUtil.BROWN;
                        break;
                    }
                    case METAL: {
                        color = ColorUtil.DARK_GRAY;
                        break;
                    }
                    case DIRT: {
                        color = ColorUtil.LIGHT_BROWN;
                        break;
                    }
                    case LAVA: {
                        color = ColorUtil.ORANGE;
                        break;
                    }
                    case DEEPSLATE: {
                        color = ColorUtil.BLACK;
                        break;
                    }
                    case SNOW: {
                        color = ColorUtil.WHITE;
                        break;
                    }
                    case SAND: {
                        color = ColorUtil.TAN;
                        break;
                    }
                    case TERRACOTTA: {
                        color = ColorUtil.DARK_ORANGE;
                        break;
                    }
                    case NETHER_STONE: {
                        color = ColorUtil.DARK_RED;
                        break;
                    }
                    case WATER: {
                        color = ColorUtil.BLUE;
                        break;
                    }
                    case GRASS: {
                        color = ColorUtil.GREEN;
                        break;
                    }
                    case ILLUMINATED: {
                        color = ColorUtil.YELLOW;
                        break;
                    }
                    default: {
                        color = ColorUtil.CYAN;
                    }
                }
                fullBright = true;
                break;
            }
            case SHOW_OVERLAPPING_QUADS: {
                color = ColorUtil.WHITE;
                fullBright = true;
                break;
            }
            case SHOW_RENDER_SOURCE_FLAG: {
                color = debugSource == null ? ColorUtil.RED : debugSource.color;
                fullBright = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown debug mode: " + (Object)((Object)debugging));
            }
        }
        ColumnBox.addBoxQuadsToBuilder(quadBuilder, phantomArrayCheckout, clientLevel, blockWidth, blockMaxY, blockMinX, blockMinY, blockMinZ, color, blockMaterialId, RenderDataPointUtil.getLightSky(renderData), fullBright ? (byte)15 : (byte)RenderDataPointUtil.getLightBlock(renderData), topRenderData, bottomRenderData, adjColumnViews, isSameDetailLevel);
    }
}

