/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.logistics.cashRegister;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.content.equipment.clipboard.ClipboardEntry;
import com.simibubi.create.content.logistics.BigItemStack;
import dev.khloeleclair.create.additionallogistics.common.CALLang;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record SalesHistoryData(@Nullable Map<String, ResourceLocation> itemMap, @Nullable Map<String, UUID> playerMap, @Nullable List<Sale> saleList) {
    public static final SalesHistoryData EMPTY = new SalesHistoryData(null, null, null);
    public static final Codec<SalesHistoryData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)ResourceLocation.CODEC).fieldOf("items").forGetter(SalesHistoryData::itemMap), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)UUIDUtil.CODEC).fieldOf("players").forGetter(SalesHistoryData::playerMap), (App)Sale.CODEC.listOf().fieldOf("sales").forGetter(SalesHistoryData::saleList)).apply((Applicative)instance, SalesHistoryData::new));

    public SalesHistoryData withBigSale(UUID player, Collection<BigItemStack> payment, Collection<BigItemStack> purchase) {
        Object p;
        ArrayList<Sale> workingSales = this.saleList == null ? new ArrayList<Sale>() : new ArrayList<Sale>(this.saleList);
        HashBiMap workingItems = this.itemMap == null ? HashBiMap.create() : HashBiMap.create(this.itemMap);
        HashBiMap workingPlayers = this.playerMap == null ? HashBiMap.create() : HashBiMap.create(this.playerMap);
        Map<String, Integer> result = SalesHistoryData.convertBigItemList((BiMap<String, ResourceLocation>)workingItems, payment);
        Map<String, Integer> other = SalesHistoryData.convertBigItemList((BiMap<String, ResourceLocation>)workingItems, purchase);
        if (workingPlayers.containsValue((Object)player)) {
            p = (String)workingPlayers.inverse().get((Object)player);
        } else {
            p = "" + (workingPlayers.size() + 1);
            workingPlayers.put(p, (Object)player);
        }
        workingSales.add(new Sale(Instant.now().getEpochSecond(), (String)p, result, other));
        return new SalesHistoryData((Map<String, ResourceLocation>)workingItems, (Map<String, UUID>)workingPlayers, workingSales);
    }

    public List<Sale> getSales() {
        return this.saleList == null ? List.of() : this.saleList;
    }

    public Map<String, ResourceLocation> getItems() {
        return this.itemMap == null ? Map.of() : this.itemMap;
    }

    public Map<String, UUID> getPlayers() {
        return this.playerMap == null ? Map.of() : this.playerMap;
    }

    @Nullable
    public List<List<ClipboardEntry>> toPurchaseClipboardEntries() {
        if (this.saleList == null || this.saleList.isEmpty()) {
            return null;
        }
        ArrayList<ClipboardEntry> entries = new ArrayList<ClipboardEntry>();
        Object2IntArrayMap purchases = new Object2IntArrayMap();
        for (Sale sale : this.getSales()) {
            for (Map.Entry<String, Integer> entry : sale.purchase().entrySet()) {
                purchases.put(entry.getKey(), purchases.getOrDefault(entry.getKey(), 0) + entry.getValue());
            }
        }
        for (Map.Entry entry : purchases.entrySet()) {
            Item item = this.getItem((String)entry.getKey());
            if (item == null) continue;
            entries.add(new ClipboardEntry(false, Component.empty()).displayItem(item.getDefaultInstance(), ((Integer)entry.getValue()).intValue()));
        }
        if (!entries.isEmpty()) {
            return List.of(entries);
        }
        return null;
    }

    public SalesHistoryData withSale(UUID player, Collection<ItemStack> payment, Collection<ItemStack> purchase) {
        Object p;
        ArrayList<Sale> workingSales = this.saleList == null ? new ArrayList<Sale>() : new ArrayList<Sale>(this.saleList);
        HashBiMap workingItems = this.itemMap == null ? HashBiMap.create() : HashBiMap.create(this.itemMap);
        HashBiMap workingPlayers = this.playerMap == null ? HashBiMap.create() : HashBiMap.create(this.playerMap);
        Map<String, Integer> result = SalesHistoryData.convertItemList((BiMap<String, ResourceLocation>)workingItems, payment);
        Map<String, Integer> other = SalesHistoryData.convertItemList((BiMap<String, ResourceLocation>)workingItems, purchase);
        if (workingPlayers.containsValue((Object)player)) {
            p = (String)workingPlayers.inverse().get((Object)player);
        } else {
            p = "" + (workingPlayers.size() + 1);
            workingPlayers.put(p, (Object)player);
        }
        workingSales.add(new Sale(Instant.now().getEpochSecond(), (String)p, result, other));
        return new SalesHistoryData((Map<String, ResourceLocation>)workingItems, (Map<String, UUID>)workingPlayers, workingSales);
    }

    @Nullable
    public MutableComponent getTimeRange(ChatFormatting ... date_formats) {
        if (this.saleList == null || this.saleList.isEmpty()) {
            return null;
        }
        Instant start_instant = this.saleList.getFirst().toInstant();
        Instant end_instant = this.saleList.getLast().toInstant();
        ZoneId where = ZoneId.systemDefault();
        ZonedDateTime start = start_instant.atZone(where);
        ZonedDateTime end = end_instant.atZone(where);
        boolean same_day = end.toLocalDate().equals(start.toLocalDate());
        return CALLang.translate("sales.date-range", Component.literal((String)start.format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT))).withStyle(date_formats), Component.literal((String)end.format(same_day ? DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT) : DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT))).withStyle(date_formats)).component();
    }

    @Nullable
    public Sale firstSale() {
        return this.saleList != null && !this.saleList.isEmpty() ? this.saleList.getFirst() : null;
    }

    @Nullable
    public Sale lastSale() {
        return this.saleList != null && !this.saleList.isEmpty() ? this.saleList.getLast() : null;
    }

    public int saleCount() {
        return this.saleList == null ? 0 : this.saleList.size();
    }

    @Nullable
    public Item getItem(String id) {
        if (this.itemMap == null) {
            return null;
        }
        ResourceLocation location = this.itemMap.get(id);
        Optional optional = BuiltInRegistries.ITEM.getOptional(location);
        return optional.orElse(null);
    }

    @Nullable
    private static String memorizeItem(BiMap<String, ResourceLocation> workingItems, @Nullable Item item) {
        ResourceLocation location;
        ResourceLocation resourceLocation = location = item == null ? null : BuiltInRegistries.ITEM.getKeyOrNull((Object)item);
        if (location == null) {
            return null;
        }
        if (workingItems.containsValue((Object)location)) {
            return (String)workingItems.inverse().get((Object)location);
        }
        String id = "" + (workingItems.size() + 1);
        workingItems.put((Object)id, (Object)location);
        return id;
    }

    @NotNull
    private static Map<String, Integer> convertItemList(BiMap<String, ResourceLocation> workingItems, @Nullable Collection<ItemStack> input) {
        if (input == null || input.isEmpty()) {
            return Map.of();
        }
        Object2IntArrayMap result = new Object2IntArrayMap();
        for (ItemStack stack : input) {
            String id = SalesHistoryData.memorizeItem(workingItems, stack.getItem());
            if (id == null) continue;
            int amount = result.getOrDefault((Object)id, 0) + stack.getCount();
            result.put((Object)id, amount);
        }
        return result;
    }

    @NotNull
    private static Map<String, Integer> convertBigItemList(BiMap<String, ResourceLocation> workingItems, @Nullable Collection<BigItemStack> input) {
        if (input == null || input.isEmpty()) {
            return Map.of();
        }
        Object2IntArrayMap result = new Object2IntArrayMap();
        for (BigItemStack stack : input) {
            String id = SalesHistoryData.memorizeItem(workingItems, stack.stack.getItem());
            if (id == null) continue;
            int amount = result.getOrDefault((Object)id, 0) + stack.count;
            result.put((Object)id, amount);
        }
        return result;
    }

    public record Sale(long timestamp, String player, Map<String, Integer> payment, Map<String, Integer> purchase) {
        public static Codec<Sale> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("t").forGetter(Sale::timestamp), (App)Codec.STRING.fieldOf("p").forGetter(Sale::player), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT).fieldOf("i").forGetter(Sale::payment), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT).fieldOf("o").forGetter(Sale::purchase)).apply((Applicative)instance, Sale::new));

        public Instant toInstant() {
            return Instant.ofEpochSecond(this.timestamp);
        }
    }
}

