/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.kinetics.verticalBelt;

import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.verticalBelt.VerticalBeltBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.verticalBelt.VerticalBeltHelper;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class VerticalBeltInventory {
    final VerticalBeltBlockEntity belt;
    private final List<TransportedItemStack> items;
    final List<TransportedItemStack> toInsert;
    final List<TransportedItemStack> toRemove;
    boolean beltMovementPositive;
    final float SEGMENT_WINDOW = 0.75f;
    @Nullable
    TransportedItemStack lazyClientItem;

    public VerticalBeltInventory(VerticalBeltBlockEntity be) {
        this.belt = be;
        this.items = new LinkedList<TransportedItemStack>();
        this.toInsert = new LinkedList<TransportedItemStack>();
        this.toRemove = new LinkedList<TransportedItemStack>();
    }

    public void tick() {
    }

    protected TransportedItemStackHandlerBehaviour getTransportedItemStackHandlerAtSegment(int segment) {
        return (TransportedItemStackHandlerBehaviour)BlockEntityBehaviour.get((BlockGetter)this.belt.getLevel(), (BlockPos)VerticalBeltHelper.getPositionForOffset(this.belt, segment), (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE);
    }

    private Ending resolveEnding() {
        BlockPos nextPosition;
        Level world = this.belt.getLevel();
        DirectBeltInputBehaviour inputBehaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)(nextPosition = VerticalBeltHelper.getPositionForOffset(this.belt, this.beltMovementPositive ? this.belt.beltHeight : -1)), (BehaviourType)DirectBeltInputBehaviour.TYPE);
        if (inputBehaviour != null) {
            return Ending.INSERT;
        }
        if (BlockHelper.hasBlockSolidSide((BlockState)world.getBlockState(nextPosition), (BlockGetter)world, (BlockPos)nextPosition, (Direction)(this.beltMovementPositive ? Direction.DOWN : Direction.UP))) {
            return Ending.BLOCKED;
        }
        return Ending.EJECT;
    }

    public boolean canInsertAt(int segment) {
        return this.canInsertAtFromSide(segment, Direction.NORTH);
    }

    public boolean canInsertAtFromSide(int segment, Direction side) {
        return false;
    }

    public void addItem(TransportedItemStack newStack) {
        this.toInsert.add(newStack);
    }

    private void insert(TransportedItemStack newStack) {
        if (this.items.isEmpty()) {
            this.items.add(newStack);
        } else {
            int index = 0;
            for (TransportedItemStack stack : this.items) {
                if (stack.compareTo(newStack) > 0 == this.beltMovementPositive) break;
                ++index;
            }
            this.items.add(index, newStack);
        }
    }

    @Nullable
    public TransportedItemStack getStackAtOffset(int offset) {
        float min = offset;
        float max = offset + 1;
        for (TransportedItemStack stack : this.items) {
            if (this.toRemove.contains(stack) || stack.beltPosition > max || !(stack.beltPosition > min)) continue;
            return stack;
        }
        return null;
    }

    public void read(CompoundTag nbt, HolderLookup.Provider registries) {
        this.items.clear();
        nbt.getList("Items", 10).forEach(inbt -> this.items.add(TransportedItemStack.read((CompoundTag)((CompoundTag)inbt), (HolderLookup.Provider)registries)));
        if (nbt.contains("LazyItem")) {
            this.lazyClientItem = TransportedItemStack.read((CompoundTag)nbt.getCompound("LazyItem"), (HolderLookup.Provider)registries);
        }
        this.beltMovementPositive = nbt.getBoolean("PositiveOrder");
    }

    public CompoundTag write(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        ListTag itemsTag = new ListTag();
        this.items.forEach(stack -> itemsTag.add((Object)stack.serializeNBT(registries)));
        tag.put("Items", (Tag)itemsTag);
        if (this.lazyClientItem != null) {
            tag.put("LazyItem", (Tag)this.lazyClientItem.serializeNBT(registries));
        }
        tag.putBoolean("PositiveOrder", this.beltMovementPositive);
        return tag;
    }

    public List<TransportedItemStack> getTransportedItems() {
        return this.items;
    }

    @Nullable
    public TransportedItemStack getLazyClientItem() {
        return this.lazyClientItem;
    }

    private static enum Ending {
        UNRESOLVED(0.0f),
        EJECT(0.0f),
        INSERT(0.25f),
        BLOCKED(0.45f);

        private float margin;

        private Ending(float f) {
            this.margin = f;
        }
    }
}

