/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.kinetics.verticalBelt;

import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.item.ItemHelper;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.verticalBelt.VerticalBeltInventory;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class ItemHandlerVerticalBeltSegment
implements IItemHandler {
    private final VerticalBeltInventory beltInventory;
    int offset;

    public ItemHandlerVerticalBeltSegment(VerticalBeltInventory beltInventory, int offset) {
        this.beltInventory = beltInventory;
        this.offset = offset;
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        TransportedItemStack stack = this.beltInventory.getStackAtOffset(this.offset);
        if (stack == null) {
            return ItemStack.EMPTY;
        }
        return stack.stack;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.beltInventory.canInsertAt(this.offset)) {
            ItemStack remainder = ItemHelper.limitCountToMaxStackSize((ItemStack)stack, (boolean)simulate);
            if (!simulate) {
                TransportedItemStack newStack = new TransportedItemStack(stack);
                newStack.insertedAt = this.offset;
                newStack.prevBeltPosition = newStack.beltPosition = (float)this.offset + 0.5f + (float)(this.beltInventory.beltMovementPositive ? -1 : 1) / 16.0f;
                this.beltInventory.addItem(newStack);
                this.beltInventory.belt.setChanged();
                this.beltInventory.belt.sendData();
            }
            return remainder;
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack extracted;
        TransportedItemStack transported = this.beltInventory.getStackAtOffset(this.offset);
        if (transported == null) {
            return ItemStack.EMPTY;
        }
        amount = Math.min(amount, transported.stack.getCount());
        ItemStack itemStack = extracted = simulate ? transported.stack.copy().split(amount) : transported.stack.split(amount);
        if (!simulate) {
            if (transported.stack.isEmpty()) {
                this.beltInventory.toRemove.add(transported);
            } else {
                this.beltInventory.belt.notifyUpdate();
            }
        }
        return extracted;
    }

    public int getSlotLimit(int slot) {
        return Math.min((Integer)this.getStackInSlot(slot).getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)64), 64);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }
}

