/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics;

import com.mojang.logging.LogUtils;
import com.simibubi.create.content.contraptions.actors.seat.SeatBlock;
import com.simibubi.create.content.contraptions.actors.seat.SeatEntity;
import com.simibubi.create.content.logistics.stockTicker.StockTickerInteractionHandler;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.khloeleclair.create.additionallogistics.common.Config;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.lazy.base.AbstractLowEntityKineticBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.datagen.DataGen;
import dev.khloeleclair.create.additionallogistics.common.registries.CALBlockEntityTypes;
import dev.khloeleclair.create.additionallogistics.common.registries.CALBlocks;
import dev.khloeleclair.create.additionallogistics.common.registries.CALDataComponents;
import dev.khloeleclair.create.additionallogistics.common.registries.CALDataMaps;
import dev.khloeleclair.create.additionallogistics.common.registries.CALEntityTypes;
import dev.khloeleclair.create.additionallogistics.common.registries.CALItems;
import dev.khloeleclair.create.additionallogistics.common.registries.CALMenuTypes;
import dev.khloeleclair.create.additionallogistics.common.registries.CALPackets;
import dev.khloeleclair.create.additionallogistics.common.registries.CALPartialModels;
import dev.khloeleclair.create.additionallogistics.common.registries.CALStress;
import dev.khloeleclair.create.additionallogistics.common.registries.CALTags;
import dev.khloeleclair.create.additionallogistics.common.utilities.CurrencyUtilities;
import dev.khloeleclair.create.additionallogistics.common.utilities.RecipeHelper;
import dev.khloeleclair.create.additionallogistics.compat.computercraft.CALComputerCraftProxy;
import java.util.List;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Mod(value="createadditionallogistics")
public class CreateAdditionalLogistics {
    public static final String MODID = "createadditionallogistics";
    public static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private static MinecraftServer server;
    public static final NonNullSupplier<CreateRegistrate> REGISTRATE;

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    @Nullable
    public static MinecraftServer getServer() {
        return server;
    }

    public CreateAdditionalLogistics(IEventBus modEventBus, ModContainer modContainer) {
        ((CreateRegistrate)REGISTRATE.get()).registerEventListeners(modEventBus);
        CurrencyUtilities.init();
        CALTags.init();
        CALBlocks.register();
        CALItems.register();
        CALMenuTypes.register();
        CALEntityTypes.register();
        CALBlockEntityTypes.register();
        CALStress.register();
        CALPartialModels.register();
        CALComputerCraftProxy.register();
        CALDataComponents.register(modEventBus);
        CALDataMaps.register(modEventBus);
        modEventBus.addListener(CALPackets::register);
        modEventBus.addListener(EventPriority.HIGHEST, DataGen::gatherData);
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.addListener(CurrencyUtilities::onDataMapUpdated);
        NeoForge.EVENT_BUS.addListener(RecipeHelper::onRecipesUpdated);
        NeoForge.EVENT_BUS.addListener(AbstractLowEntityKineticBlockEntity::onTick);
        Config.register(modContainer);
    }

    @SubscribeEvent
    private void onServerStart(ServerStartingEvent event) {
        server = event.getServer();
    }

    @SubscribeEvent
    private void onServerStopped(ServerStoppedEvent event) {
        server = null;
    }

    @SubscribeEvent
    private void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Entity passenger;
        BlockPos ticker;
        List passengers;
        List seats;
        if (!((Boolean)Config.Common.protectStockKeeperSeats.get()).booleanValue()) {
            return;
        }
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        if (level.getBlockState(pos).getBlock() instanceof SeatBlock && !(seats = level.getEntitiesOfClass(SeatEntity.class, new AABB(pos))).isEmpty() && !(passengers = ((SeatEntity)seats.getFirst()).getPassengers()).isEmpty() && (ticker = StockTickerInteractionHandler.getStockTickerPosition((Entity)(passenger = (Entity)passengers.getFirst()))) != null) {
            event.setCanceled(true);
        }
    }

    static {
        REGISTRATE = NonNullSupplier.lazy(() -> CreateRegistrate.create((String)MODID).setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item)))));
    }
}

