/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.create.mechanical_chisel;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.saw.SawBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.create.mechanical_chisel.MechanicalChiselBlockEntity;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class MechanicalChiselRenderer
extends SafeBlockEntityRenderer<MechanicalChiselBlockEntity> {
    protected void renderSafe(MechanicalChiselBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnBlockEntity((SmartBlockEntity)be, (float)partialTicks, (PoseStack)ms, (MultiBufferSource)buffer, (int)light, (int)overlay);
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            this.renderShaft(be, ms, buffer, light, overlay);
        }
    }

    protected void renderShaft(MechanicalChiselBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        KineticBlockEntityRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)this.getRotatedModel(be), (PoseStack)ms, (VertexConsumer)buffer.getBuffer(RenderType.solid()), (int)light);
    }

    protected void renderItems(MechanicalChiselBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        boolean processingMode;
        boolean bl = processingMode = be.getBlockState().getValue((Property)SawBlock.FACING) == Direction.UP;
        if (processingMode && !be.inventory.isEmpty()) {
            float offset;
            boolean alongZ = (Boolean)be.getBlockState().getValue((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
            ms.pushPose();
            boolean moving = be.inventory.recipeDuration != 0.0f;
            float f = offset = moving ? 1.0f - be.inventory.remainingTime / be.inventory.recipeDuration : 0.0f;
            if (be.inventory.appliedRecipe) {
                offset += 1.0f;
            }
            if (moving) {
                float processingSpeed = Mth.clamp((float)(Math.abs(be.getSpeed()) / 24.0f), (float)1.0f, (float)128.0f);
                offset = Mth.clamp((float)(offset + (partialTicks + 0.5f) * processingSpeed / be.inventory.recipeDuration), (float)0.125f, (float)2.0f);
                offset /= 2.0f;
            }
            float chiselProgress = offset > 0.4f ? (offset > 0.6f ? Math.max(1.0f - (offset - 0.6f) / 0.2f, 0.0f) : (offset - 0.4f) / 0.2f) : 0.0f;
            this.renderChisel(be, ms, buffer, light, overlay, chiselProgress);
            offset = offset < 0.4f || offset > 0.6f ? (offset < 0.4f ? offset / 0.8f : 0.5f + (offset - 0.6f) / 0.8f) : 0.5f;
            if (be.getSpeed() == 0.0f) {
                offset = 0.5f;
            }
            if (be.getSpeed() > 0.0f ^ alongZ) {
                offset = 1.0f - offset;
            }
            for (int i = 0; i < be.inventory.getSlots(); ++i) {
                ItemStack stack = be.inventory.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
                BakedModel modelWithOverrides = itemRenderer.getModel(stack, be.getLevel(), null, 0);
                boolean blockItem = modelWithOverrides.isGui3d();
                ms.translate(alongZ ? (double)offset : 0.5, blockItem ? (double)0.925f : 0.8125, alongZ ? 0.5 : (double)offset);
                ms.scale(0.5f, 0.5f, 0.5f);
                if (alongZ) {
                    ms.mulPose(new Quaternionf().rotateY(1.5707964f));
                }
                ms.mulPose(new Quaternionf().rotateX(1.5707964f));
                itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, light, overlay, ms, buffer, be.getLevel(), 0);
                break;
            }
            ms.popPose();
        } else {
            this.renderChisel(be, ms, buffer, light, overlay, 0.0f);
        }
    }

    private void renderChisel(MechanicalChiselBlockEntity be, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, float progress) {
        Direction facing = (Direction)be.getBlockState().getValue((Property)SawBlock.FACING);
        if (facing.getAxis() != Direction.Axis.Y) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        if (((Boolean)be.getBlockState().getValue((Property)SawBlock.FLIPPED)).booleanValue()) {
            poseStack.mulPose(new Quaternionf().rotateY((float)Math.PI));
        }
        if (((Boolean)be.getBlockState().getValue((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE)).booleanValue()) {
            poseStack.mulPose(new Quaternionf().rotateY((float)Math.PI));
        } else {
            poseStack.mulPose(new Quaternionf().rotateY(1.5707964f));
        }
        if (facing == Direction.DOWN) {
            poseStack.mulPose(new Quaternionf().rotateZ((float)Math.PI));
        }
        poseStack.translate(0.25, 0.6, 0.0);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.translate(0.2, -0.2, 0.0);
        poseStack.mulPose(new Quaternionf().rotateZ(progress * (float)Math.PI / 2.0f));
        poseStack.translate(-0.2, 0.2, 0.0);
        ClientUtils.getItemRenderer().renderStatic(Rechiseled.chisel.getDefaultInstance(), ItemDisplayContext.FIXED, light, overlay, poseStack, buffer, be.getLevel(), 0);
        poseStack.popPose();
    }

    protected SuperByteBuffer getRotatedModel(KineticBlockEntity be) {
        BlockState state = be.getBlockState();
        return ((Direction)state.getValue((Property)BlockStateProperties.FACING)).getAxis().isHorizontal() ? CachedBuffers.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)state.rotate((LevelAccessor)be.getLevel(), be.getBlockPos(), Rotation.CLOCKWISE_180)) : CachedBuffers.block((SuperByteBufferCache.Compartment)KineticBlockEntityRenderer.KINETIC_BLOCK, (BlockState)this.getRenderedBlockState(be));
    }

    protected BlockState getRenderedBlockState(KineticBlockEntity be) {
        return KineticBlockEntityRenderer.shaft((Direction.Axis)KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }
}

