/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.wires;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Transformation;
import java.util.Optional;
import mrtjp.projectred.fabrication.engine.BaseTile;
import mrtjp.projectred.fabrication.engine.ICTileType;
import mrtjp.projectred.fabrication.engine.IConnectableICTile;
import mrtjp.projectred.fabrication.engine.IRotatableICTile;
import mrtjp.projectred.transmission.WireType;
import mrtjp.projectred.transmission.client.WireModelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;

public abstract class WireTile
extends BaseTile
implements IConnectableICTile {
    private static final int PACKET_CONN_MASK = 1;
    private final WireType renderType;
    private byte connMask = 0;

    public WireTile(ICTileType tileType, WireType renderType) {
        super(tileType);
        this.renderType = renderType;
    }

    public WireType getWireType() {
        return this.renderType;
    }

    @Override
    public int getConnMask() {
        return this.connMask & 0xFF;
    }

    @Override
    public void setConnMask(int connMask) {
        this.connMask = (byte)connMask;
    }

    @Override
    public void save(CompoundTag tag) {
        tag.putByte("connMask", this.connMask);
    }

    @Override
    public void load(CompoundTag tag) {
        this.connMask = tag.getByte("connMask");
    }

    @Override
    public void writeDesc(MCDataOutput out) {
        out.writeByte((int)this.connMask);
    }

    @Override
    public void readDesc(MCDataInput in) {
        this.connMask = in.readByte();
    }

    @Override
    public void read(MCDataInput in, int key) {
        switch (key) {
            case 1: {
                this.connMask = in.readByte();
                break;
            }
            default: {
                super.read(in, key);
            }
        }
    }

    protected void sendConnUpdate() {
        this.getWriteStream(1).writeByte((int)this.connMask);
    }

    @Override
    public void onMaskChanged() {
        this.sendConnUpdate();
        this.getEditor().markTileChange();
    }

    @Override
    public void onNeighborChanged() {
        super.onNeighborChanged();
        this.updateConns();
    }

    @Override
    public void onAdded() {
        super.onAdded();
        this.updateConns();
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        for (int s = 0; s < 6; ++s) {
            this.getEditor().queueNeighborChange(this.getPos().offset(s));
        }
    }

    @Override
    public IConnectableICTile getTileTowardsDir(int dir) {
        Optional<BaseTile> tile = this.getMap().getBaseTile(this.getPos().offset(dir));
        if (tile.isPresent() && tile.get() instanceof IConnectableICTile) {
            return (IConnectableICTile)((Object)tile.get());
        }
        return null;
    }

    protected int getRenderHue() {
        return -1;
    }

    protected int getTextureIndex() {
        return 0;
    }

    @Override
    public void renderTile(CCRenderState ccrs, Transformation t, float partialFrame) {
        int rmask = IRotatableICTile.dirMaskToRotationMask(this.getConnMask());
        int wireConnMask = rmask << 4;
        int modelKey = WireModelRenderer.modelKey((int)0, (int)this.getWireType().getThickness(), (int)wireConnMask);
        WireModelRenderer.render((CCRenderState)ccrs, (int)modelKey, (int)this.getRenderHue(), (TextureAtlasSprite)((TextureAtlasSprite)this.getWireType().getTextures().get(this.getTextureIndex())), (Transformation)t);
    }
}

