/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import mrtjp.fengine.simulate.ICGate;
import mrtjp.fengine.simulate.ICSimulation;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.SimpleGateTile;

public class BufferGateTile
extends SimpleGateTile {
    public BufferGateTile() {
        super(ICGateTileType.BUFFER);
    }

    @Override
    protected int redstoneOutputMask() {
        return ~((this.getShape() & 1) << 1 | (this.getShape() & 2) << 2) & 0xB;
    }

    @Override
    protected int redstoneInputMask() {
        return 4;
    }

    @Override
    protected int interactMask() {
        return 10;
    }

    @Override
    protected int getDeadSides() {
        return 2;
    }

    @Override
    protected int getMaxDeadSides() {
        return 2;
    }

    @Override
    protected int rotationToDeadSideBit(int r) {
        return switch (r) {
            case 1 -> 1;
            case 3 -> 2;
            default -> 0;
        };
    }

    @Override
    public ICGate createGate() {
        return new BufferGate();
    }

    public static class BufferGate
    implements ICGate {
        public void compute(ICSimulation ic, int[] inputs, int[] outputs) {
            for (int i = 0; i < outputs.length; ++i) {
                ic.queueRegByteVal(outputs[i], ic.getRegByteVal(inputs[0]) != 0 ? (byte)1 : 0);
            }
        }
    }
}

