/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication;

import codechicken.multipart.api.MultipartType;
import mrtjp.projectred.fabrication.data.FabricationBlockStateModelProvider;
import mrtjp.projectred.fabrication.data.FabricationBlockTagsProvider;
import mrtjp.projectred.fabrication.data.FabricationItemModelProvider;
import mrtjp.projectred.fabrication.data.FabricationLanguageProvider;
import mrtjp.projectred.fabrication.data.FabricationLootTableProvider;
import mrtjp.projectred.fabrication.data.FabricationRecipeProvider;
import mrtjp.projectred.fabrication.init.FabricationBlocks;
import mrtjp.projectred.fabrication.init.FabricationClientInit;
import mrtjp.projectred.fabrication.init.FabricationCreativeModeTab;
import mrtjp.projectred.fabrication.init.FabricationDataComponents;
import mrtjp.projectred.fabrication.init.FabricationItems;
import mrtjp.projectred.fabrication.init.FabricationMenus;
import mrtjp.projectred.fabrication.init.FabricationParts;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod(value="projectred_fabrication")
public class ProjectRedFabrication {
    public static final String MOD_ID = "projectred_fabrication";
    public static final Logger LOGGER = LogManager.getLogger((String)"projectred_fabrication");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"projectred_fabrication");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"projectred_fabrication");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"projectred_fabrication");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"projectred_fabrication");
    public static final DeferredRegister<MultipartType<?>> PARTS = DeferredRegister.create((ResourceKey)MultipartType.MULTIPART_TYPES, (String)"projectred_fabrication");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"projectred_fabrication");
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"projectred_fabrication");
    @Nullable
    private static ModContainer container;

    public ProjectRedFabrication(ModContainer container, IEventBus modEventBus) {
        ProjectRedFabrication.container = container;
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onGatherDataEvent);
        if (FMLEnvironment.dist.isClient()) {
            FabricationClientInit.init(modEventBus);
        }
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITY_TYPES.register(modEventBus);
        MENU_TYPES.register(modEventBus);
        PARTS.register(modEventBus);
        CREATIVE_TABS.register(modEventBus);
        DATA_COMPONENT_TYPES.register(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void onGatherDataEvent(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new FabricationBlockStateModelProvider(output, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new FabricationItemModelProvider(output, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new FabricationLanguageProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new FabricationBlockTagsProvider(output, event.getLookupProvider(), fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new FabricationLootTableProvider(output, event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new FabricationRecipeProvider(event.getLookupProvider(), output));
    }

    static {
        FabricationBlocks.register();
        FabricationMenus.register();
        FabricationItems.register();
        FabricationParts.register();
        FabricationCreativeModeTab.register();
        FabricationDataComponents.register();
    }
}

