/*
 * Decompiled with CFR 0.152.
 */
package betterdays.client.gui;

import betterdays.client.gui.ScreenAlignment;
import betterdays.config.ConfigHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SleepGui {
    private static ItemStack clock = new ItemStack((ItemLike)Items.CLOCK);

    public static void onClientTick(Minecraft minecraft) {
        if (minecraft.player != null && minecraft.player.isSleeping() && ConfigHandler.Client.preventClockWobble() && minecraft.level != null && !minecraft.isPaused() && SleepGui.clockEnabled()) {
            minecraft.getItemRenderer().getModel(clock, (Level)minecraft.level, (LivingEntity)minecraft.player, 0);
        }
    }

    public static void onGuiEvent(Screen screen, GuiGraphics guiGraphics) {
        if (SleepGui.clockEnabled()) {
            SleepGui.renderSleepInterface(screen, guiGraphics);
        }
    }

    public static void renderSleepInterface(Screen screen, GuiGraphics guiGraphics) {
        int scale = ConfigHandler.Client.clockScale();
        int margin = ConfigHandler.Client.clockMargin();
        ScreenAlignment alignment = ConfigHandler.Client.clockAlignment();
        float x = alignment == ScreenAlignment.TOP_LEFT || alignment == ScreenAlignment.CENTER_LEFT || alignment == ScreenAlignment.BOTTOM_LEFT ? (float)margin : (alignment == ScreenAlignment.TOP_CENTER || alignment == ScreenAlignment.CENTER_CENTER || alignment == ScreenAlignment.BOTTOM_CENTER ? (float)(screen.width / 2 - scale / 2) : (float)(screen.width - scale - margin));
        float y = alignment == ScreenAlignment.TOP_LEFT || alignment == ScreenAlignment.TOP_CENTER || alignment == ScreenAlignment.TOP_RIGHT ? (float)margin : (alignment == ScreenAlignment.CENTER_LEFT || alignment == ScreenAlignment.CENTER_CENTER || alignment == ScreenAlignment.CENTER_RIGHT ? (float)(screen.height / 2 - scale / 2) : (float)(screen.height - scale - margin));
        SleepGui.renderClock(guiGraphics, x, y, scale);
    }

    public static void renderClock(GuiGraphics guiGraphics, float x, float y, float scale) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(x, y, 0.0f);
        guiGraphics.pose().scale(scale /= 16.0f, scale, 0.0f);
        guiGraphics.renderItem(clock, 0, 0);
        guiGraphics.pose().popPose();
    }

    public static boolean clockEnabled() {
        return ConfigHandler.Common.enableSleepFeature() && ConfigHandler.Common.displayBedClock();
    }
}

