/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour;

import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createenchantmentindustry.common.fluids.printer.PrinterBlockEntity;
import plus.dragons.createenchantmentindustry.common.fluids.printer.PrintingInput;
import plus.dragons.createenchantmentindustry.common.fluids.printer.PrintingRecipe;
import plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour.PrintingBehaviour;
import plus.dragons.createenchantmentindustry.common.registry.CEIRecipes;
import plus.dragons.createenchantmentindustry.config.CEIConfig;
import plus.dragons.createenchantmentindustry.util.CEILang;

public class RecipePrintingBehaviour
implements PrintingBehaviour {
    public static final RecipePrintingBehaviour EMPTY = new RecipePrintingBehaviour(ItemStack.EMPTY);
    private final ItemStack template;
    @Nullable
    private RecipeHolder<PrintingRecipe> lastRecipe;

    public RecipePrintingBehaviour(ItemStack template) {
        this.template = template;
    }

    private Optional<PrintingRecipe> findRecipe(Level level, ItemStack stack, FluidStack fluidStack) {
        PrintingInput input = new PrintingInput(stack, this.template, fluidStack);
        Optional holder = SequencedAssemblyRecipe.getRecipe((Level)level, (RecipeInput)input, (RecipeType)CEIRecipes.PRINTING.getType(), PrintingRecipe.class);
        if (holder.isPresent()) {
            this.lastRecipe = (RecipeHolder)holder.get();
            return holder.map(RecipeHolder::value);
        }
        holder = level.getRecipeManager().getRecipeFor(CEIRecipes.PRINTING.getType(), (RecipeInput)input, level, this.lastRecipe);
        if (holder.isPresent()) {
            this.lastRecipe = (RecipeHolder)holder.get();
            return holder.map(RecipeHolder::value);
        }
        this.lastRecipe = null;
        return Optional.empty();
    }

    @Override
    public boolean isValid() {
        return !this.template.isEmpty();
    }

    @Override
    public int getRequiredItemCount(Level level, ItemStack stack) {
        return this.findRecipe(level, stack, FluidStack.EMPTY).isPresent() ? 1 : 0;
    }

    @Override
    public int getRequiredFluidAmount(Level level, ItemStack stack, FluidStack fluidStack) {
        return this.findRecipe(level, stack, fluidStack).map(recipe -> ((SizedFluidIngredient)recipe.getFluidIngredients().getFirst()).amount()).orElse(0);
    }

    @Override
    public ItemStack getResult(Level level, ItemStack stack, FluidStack fluidStack) {
        return this.findRecipe(level, stack, fluidStack).map(recipe -> ((ProcessingOutput)recipe.getRollableResults().getFirst()).getStack()).orElse(ItemStack.EMPTY);
    }

    @Override
    public void onFinished(Level level, BlockPos pos, PrinterBlockEntity printer) {
        if (this.lastRecipe != null) {
            ((PrintingRecipe)this.lastRecipe.value()).playSound(level, pos.below(), SoundSource.BLOCKS);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.template.isEmpty()) {
            return false;
        }
        CEILang.translate("gui.goggles.printing.template", new Object[0]).forGoggles(tooltip);
        CEILang.item(this.template).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        if (this.lastRecipe != null) {
            int cost = ((PrintingRecipe)this.lastRecipe.value()).getFluidIngredients().size();
            CEILang.translate("gui.goggles.printing.cost", CEILang.number(((PrintingRecipe)this.lastRecipe.value()).getFluidIngredients().size()).add(CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0])).style(cost <= (Integer)CEIConfig.fluids().printerFluidCapacity.get() ? ChatFormatting.GREEN : ChatFormatting.RED)).forGoggles(tooltip, 1);
        }
        return true;
    }
}

