/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.config.ConfigScreen;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import xyz.faewulf.lib.Constants;
import xyz.faewulf.lib.util.config.ConfigLoaderFromAnnotation;
import xyz.faewulf.lib.util.config.ConfigScreen.Components.GroupButton;
import xyz.faewulf.lib.util.config.ConfigScreen.Components.IntSliderButton;
import xyz.faewulf.lib.util.config.ConfigScreen.Components.NumberButton;
import xyz.faewulf.lib.util.config.ConfigScreen.Components.NumberButtonInfo;
import xyz.faewulf.lib.util.config.ConfigScreen.Components.OptionButton;
import xyz.faewulf.lib.util.config.ConfigScreen.ConfigScreen;

public class ConfigTab
implements Tab {
    public Map<ConfigLoaderFromAnnotation.EntryInfo, List<AbstractWidget>> tabEntries = new LinkedHashMap<ConfigLoaderFromAnnotation.EntryInfo, List<AbstractWidget>>();
    private String MOD_ID;
    Component Title;

    public ConfigTab(String MOD_ID, String title, Map<String, ConfigLoaderFromAnnotation.EntryInfo> entry) {
        this.Title = Component.translatable((String)(MOD_ID + ".config.category." + title));
        ConfigLoaderFromAnnotation.getGroups(MOD_ID, title).forEach(group -> {
            final GroupButton groupButton = new GroupButton((Component)Component.literal((String)group));
            this.tabEntries.put(new ConfigLoaderFromAnnotation.EntryInfo((String)group), (List<AbstractWidget>)new ArrayList<AbstractWidget>(){
                {
                    this.add(groupButton);
                }
            });
            entry.forEach((s1, entryInfo) -> {
                if (entryInfo.hidden) {
                    return;
                }
                if (!Objects.equals(entryInfo.group, group)) {
                    return;
                }
                ArrayList<Object> buttonList = new ArrayList<Object>();
                ConfigScreen.CONFIG_ENTRIES.add((ConfigLoaderFromAnnotation.EntryInfo)entryInfo);
                ConfigScreen.CONFIG_VALUES.put(entryInfo.name, entryInfo.value);
                try {
                    Object ref = entryInfo.targetField.get(null);
                    if (ref instanceof Number) {
                        buttonList.add(new NumberButtonInfo(MOD_ID, 0, 20, (Component)Component.literal((String)s1), Minecraft.getInstance().font, (ConfigLoaderFromAnnotation.EntryInfo)entryInfo).alignLeft());
                        if (entryInfo.slider == null) {
                            buttonList.add((Object)new NumberButton(MOD_ID, Minecraft.getInstance().font, 0, 16, (Component)Component.literal((String)s1), (ConfigLoaderFromAnnotation.EntryInfo)entryInfo));
                        } else {
                            buttonList.add((Object)new IntSliderButton(MOD_ID, 0, 20, (Component)Component.literal((String)s1), (ConfigLoaderFromAnnotation.EntryInfo)entryInfo));
                        }
                    } else {
                        buttonList.add((Object)new OptionButton(MOD_ID, 20, 20, 20, 20, (Component)Component.literal((String)s1), button -> {
                            Field field = entryInfo.targetField;
                            try {
                                Object value = field.get(null);
                                if (value instanceof Boolean) {
                                    Boolean b = (Boolean)value;
                                    field.set(null, b == false);
                                }
                                if (value instanceof Enum) {
                                    Enum enumValue = (Enum)value;
                                    field.set(null, ConfigTab.getNextEnumValue(enumValue));
                                }
                            }
                            catch (IllegalAccessException e) {
                                Constants.LOG.error("[backpack] Something went wrong with the config system...");
                                e.printStackTrace();
                            }
                        }, (ConfigLoaderFromAnnotation.EntryInfo)entryInfo));
                    }
                }
                catch (IllegalAccessException e) {
                    Constants.LOG.error("[backpack] Something went wrong with the config system...");
                    e.printStackTrace();
                }
                this.tabEntries.put((ConfigLoaderFromAnnotation.EntryInfo)entryInfo, (List<AbstractWidget>)buttonList);
                groupButton.addToControlList((ConfigLoaderFromAnnotation.EntryInfo)entryInfo);
            });
        });
    }

    public boolean isShouldHideFromConfigScreen() {
        AtomicInteger realEntry = new AtomicInteger();
        this.tabEntries.forEach((entryInfo, abstractWidgets) -> {
            if (!entryInfo.pseudoEntry) {
                realEntry.getAndIncrement();
            }
        });
        return this.tabEntries.isEmpty() || realEntry.get() == 0;
    }

    public static <E extends Enum<E>> E getNextEnumValue(Enum<?> currentValue) {
        Enum[] enumValues = (Enum[])currentValue.getDeclaringClass().getEnumConstants();
        int currentIndex = currentValue.ordinal();
        int nextIndex = (currentIndex + 1) % enumValues.length;
        return (E)enumValues[nextIndex];
    }

    @NotNull
    public Component getTabTitle() {
        return this.Title;
    }

    public void visitChildren(@NotNull Consumer<AbstractWidget> consumer) {
    }

    public void doLayout(@NotNull ScreenRectangle screenRectangle) {
    }
}

