/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui.controls;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.WidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TextureBlitData;

public class ProgressBar
extends WidgetBase {
    private final TextureBlitData progressTexture;
    private final Supplier<Float> getProgress;
    private final ProgressDirection dir;

    public ProgressBar(Position position, TextureBlitData progressTexture, Supplier<Float> getProgress, ProgressDirection dir) {
        super(position, new Dimension(progressTexture.getWidth(), progressTexture.getHeight()));
        this.progressTexture = progressTexture;
        this.getProgress = getProgress;
        this.dir = dir;
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, Minecraft minecraft, int mouseX, int mouseY) {
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int height = this.progressTexture.getHeight();
        int width = this.progressTexture.getWidth();
        float progress = this.getProgress.get().floatValue();
        if (progress <= 0.0f) {
            return;
        }
        int yOffset = 0;
        if (this.dir == ProgressDirection.BOTTOM_UP) {
            yOffset = (int)((float)height * progress);
            height -= yOffset;
        } else if (this.dir == ProgressDirection.LEFT_RIGHT) {
            width = (int)((float)width * progress);
        }
        guiGraphics.blit(this.progressTexture.getTextureName(), this.x, this.y + yOffset, (float)this.progressTexture.getU(), (float)this.progressTexture.getV() + (float)yOffset, width, height, this.progressTexture.getTextureWidth(), this.progressTexture.getTextureHeight());
    }

    @Override
    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }

    public static enum ProgressDirection {
        LEFT_RIGHT,
        BOTTOM_UP;

    }
}

