/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.util;

import codechicken.lib.raytracer.SubHitBlockHitResult;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.api.part.MultiPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PartRayTraceResult
extends SubHitBlockHitResult
implements Comparable<SubHitBlockHitResult> {
    @Nullable
    public final VoxelShape hitShape;
    public final MultiPart part;
    public final double distance;
    public final BlockHitResult hit;

    public PartRayTraceResult(VoxelShape hitShape, MultiPart part, BlockHitResult hit, Vec3 start) {
        Object object;
        Vector3 vector3 = new Vector3(hit.getLocation());
        Direction direction = hit.getDirection();
        BlockPos blockPos = hit.getBlockPos();
        boolean bl = hit.isInside();
        if (hit instanceof SubHitBlockHitResult) {
            SubHitBlockHitResult sHit = (SubHitBlockHitResult)hit;
            object = sHit.hitInfo;
        } else {
            object = null;
        }
        super(vector3, direction, blockPos, bl, object, hit.getLocation().distanceToSqr(start));
        this.hitShape = hitShape;
        this.part = part;
        this.distance = hit.getLocation().distanceToSqr(start);
        this.hit = hit;
    }

    @Deprecated(forRemoval=true)
    public PartRayTraceResult(MultiPart part, SubHitBlockHitResult hit) {
        super(new Vector3(hit.getLocation()), hit.getDirection(), hit.getBlockPos(), hit.isInside(), hit.hitInfo, hit.dist);
        this.part = part;
        this.distance = hit.dist;
        this.hit = hit;
        this.hitShape = null;
    }

    @Deprecated(forRemoval=true)
    public PartRayTraceResult(MultiPart part, Vector3 hitVec, Direction faceIn, BlockPos posIn, boolean isInside, Object data, double dist) {
        super(hitVec, faceIn, posIn, isInside, data, dist);
        this.part = part;
        this.distance = dist;
        this.hit = new BlockHitResult(hitVec.vec3(), faceIn, posIn, isInside);
        this.hitShape = null;
    }

    @Override
    public int compareTo(SubHitBlockHitResult o) {
        return Double.compare(this.distance, o.dist);
    }
}

