/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.api.part;

import codechicken.lib.render.particle.CustomParticleHandler;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.util.PartRayTraceResult;
import java.util.ArrayList;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public interface IconHitEffectsPart
extends MultiPart {
    public Cuboid6 getBounds();

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getBreakingIcon(PartRayTraceResult var1);

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getBrokenIcon(int var1);

    @Override
    @OnlyIn(value=Dist.CLIENT)
    default public void addHitEffects(PartRayTraceResult hit, ParticleEngine engine) {
        IconHitEffectsPart.addHitEffects(this, hit, engine);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    default public void addDestroyEffects(PartRayTraceResult hit, ParticleEngine engine) {
        IconHitEffectsPart.addDestroyEffects(this, engine);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addHitEffects(IconHitEffectsPart part, PartRayTraceResult hit, ParticleEngine engine) {
        CustomParticleHandler.addBlockHitEffects((Level)part.level(), (Cuboid6)part.getBounds().copy().add(part.pos()), (Direction)hit.getDirection(), (TextureAtlasSprite)part.getBreakingIcon(hit), (ParticleEngine)engine);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addDestroyEffects(IconHitEffectsPart part, ParticleEngine engine) {
        IconHitEffectsPart.addDestroyEffects(part, engine, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addDestroyEffects(IconHitEffectsPart part, ParticleEngine engine, boolean scaleDensity) {
        ArrayList<TextureAtlasSprite> icons = new ArrayList<TextureAtlasSprite>(6);
        for (int i = 0; i < 6; ++i) {
            icons.add(i, part.getBrokenIcon(i));
        }
        Cuboid6 bounds = scaleDensity ? part.getBounds() : Cuboid6.full;
        CustomParticleHandler.addBlockDestroyEffects((Level)part.level(), (Cuboid6)bounds.copy().add(part.pos()), icons, (ParticleEngine)engine);
    }
}

