/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.piggyback.mixin;

import net.minecraft.commands.CommandSource;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityAccess;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements Nameable,
EntityAccess,
CommandSource {
    @Shadow
    private EntityDimensions dimensions;
    @Shadow
    private Level level;

    @Shadow
    public abstract boolean hasPassenger(Entity var1);

    @Shadow
    @Nullable
    public abstract Entity getVehicle();

    @Shadow
    public abstract void stopRiding();

    @Inject(method={"positionRider(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity$MoveFunction;)V"}, at={@At(value="TAIL")})
    private void updatePassengerPositionInject(Entity passenger, Entity.MoveFunction positionUpdater, CallbackInfo ci) {
        Entity entity;
        if (passenger instanceof Player && this.hasPassenger(passenger) && (entity = (Entity)this) instanceof Player) {
            Player player = (Player)entity;
            float h = 0.6f;
            float f = Mth.sin((float)(player.yBodyRot * ((float)Math.PI / 180)));
            float g = Mth.cos((float)(player.yBodyRot * ((float)Math.PI / 180)));
            float height = this.dimensions.height() * 0.2f;
            float baseYaw = player.yBodyRot;
            float yawDifference = Mth.wrapDegrees((float)(passenger.getYRot() - baseYaw));
            float clamped = Mth.clamp((float)yawDifference, (float)-100.0f, (float)100.0f);
            passenger.setYRot(baseYaw + clamped);
            passenger.setYBodyRot(player.yBodyRot);
            passenger.setPos(player.getX() + (double)(h * f), player.getY() + (double)height, player.getZ() - (double)(h * g));
        }
    }

    @Inject(method={"removePassenger"}, at={@At(value="TAIL")})
    private void onRemovePassenger(Entity passenger, CallbackInfo callbackInfo) {
        Entity entity = (Entity)this;
        if (!this.level.isClientSide && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.connection.send((Packet)new ClientboundSetPassengersPacket(entity));
        }
    }

    @Inject(method={"unRide"}, at={@At(value="HEAD")})
    private void onUnRide(CallbackInfo ci) {
        if (this.level.isClientSide) {
            return;
        }
        Entity vehicle = this.getVehicle();
        if (vehicle instanceof Player) {
            this.stopRiding();
        }
    }
}

