/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.network;

import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.ClientboundPacketType;
import com.teamresourceful.resourcefullib.common.network.base.Networking;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.teamresourceful.resourcefullib.common.network.base.ServerboundPacketType;
import com.teamresourceful.resourcefullib.common.network.neoforge.NetworkImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public class Network
implements Networking {
    private final Networking networking;
    private final boolean optional;

    public Network(ResourceLocation channel, int protocolVersion) {
        this(channel, protocolVersion, false);
    }

    public Network(ResourceLocation channel, int protocolVersion, boolean optional) {
        this.networking = Network.getNetwork(channel, protocolVersion, optional);
        this.optional = optional;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="22.0")
    public Network(String modid, int protocolVersion, String channel) {
        this(modid, protocolVersion, channel, false);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="22.0")
    public Network(String modid, int protocolVersion, String channel, boolean optional) {
        this.networking = Network.getNetwork(ResourceLocation.fromNamespaceAndPath((String)modid, (String)channel), protocolVersion, optional);
        this.optional = optional;
    }

    @Override
    public final <T extends Packet<T>> void register(ClientboundPacketType<T> type) {
        this.networking.register(type);
    }

    @Override
    public final <T extends Packet<T>> void register(ServerboundPacketType<T> type) {
        this.networking.register(type);
    }

    @Override
    public final <T extends Packet<T>> void sendToServer(T message) {
        this.networking.sendToServer(message);
    }

    @Override
    public final <T extends Packet<T>> void sendToPlayer(T message, ServerPlayer player) {
        if (this.optional && !this.canSendToPlayer(player, message.type())) {
            return;
        }
        this.networking.sendToPlayer(message, player);
    }

    public final <T extends Packet<T>> void sendToPlayer(T message, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.sendToPlayer(message, serverPlayer);
        }
    }

    public final <T extends Packet<T>> void sendToPlayers(T message, Collection<? extends Player> players) {
        players.forEach(player -> this.sendToPlayer(message, (Player)player));
    }

    public final <T extends Packet<T>> void sendToAllPlayers(T message, MinecraftServer server) {
        this.sendToPlayers(message, server.getPlayerList().getPlayers());
    }

    public final <T extends Packet<T>> void sendToPlayersInLevel(T message, Level level) {
        this.sendToPlayers(message, level.players());
    }

    public final <T extends Packet<T>> void sendToAllLoaded(T message, Level level, BlockPos pos) {
        ChunkSource chunkSource;
        LevelChunk chunk = level.getChunkAt(pos);
        if (chunk != null && (chunkSource = level.getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache serverCache = (ServerChunkCache)chunkSource;
            serverCache.chunkMap.getPlayers(chunk.getPos(), false).forEach(player -> this.sendToPlayer(message, (ServerPlayer)player));
        }
    }

    public final <T extends Packet<T>> void sendToPlayersInRange(T message, Level level, BlockPos pos, double range) {
        for (Player player : level.players()) {
            if (!(player.blockPosition().distSqr((Vec3i)pos) <= range)) continue;
            this.sendToPlayer(message, player);
        }
    }

    @Override
    public final boolean canSendToPlayer(ServerPlayer player, PacketType<?> type) {
        return this.networking.canSendToPlayer(player, type);
    }

    public final boolean canSendToPlayer(Player player, PacketType<?> type) {
        ServerPlayer serverPlayer;
        return player instanceof ServerPlayer && this.canSendToPlayer(serverPlayer = (ServerPlayer)player, type);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ApiStatus.Internal
    @Contract(pure=true)
    @ExpectPlatform.Transformed
    public static Networking getNetwork(ResourceLocation channel, int protocolVersion, boolean optional) {
        void var2_2;
        void var1_1;
        return NetworkImpl.getNetwork(channel, (int)var1_1, (boolean)var2_2);
    }
}

