/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util.resource;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraft.FileUtil;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.level.validation.DirectoryValidator;
import org.slf4j.Logger;

public class RequiredFolderRepositorySource
extends FolderRepositorySource {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final PackSelectionConfig DISCOVERED_PACK_SELECTION_CONFIG = new PackSelectionConfig(true, Pack.Position.TOP, false);

    public RequiredFolderRepositorySource(Path pFolder, PackType pPackType, PackSource pPackSource, DirectoryValidator directoryValidator) {
        super(pFolder, pPackType, pPackSource, directoryValidator);
    }

    public void loadPacks(Consumer<Pack> pOnLoad) {
        try {
            FileUtil.createDirectoriesSafe((Path)this.folder);
            RequiredFolderRepositorySource.discoverPacks((Path)this.folder, (DirectoryValidator)this.validator, (path, resourcesSupplier) -> {
                PackLocationInfo packLocationInfo = this.createDiscoveredFilePackInfo((Path)path);
                Pack pack = Pack.readMetaAndCreate((PackLocationInfo)packLocationInfo, (Pack.ResourcesSupplier)resourcesSupplier, (PackType)this.packType, (PackSelectionConfig)DISCOVERED_PACK_SELECTION_CONFIG);
                if (pack != null) {
                    pOnLoad.accept(pack);
                }
            });
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to list packs in {}", (Object)this.folder, (Object)ioexception);
        }
    }
}

