/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util.codec;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import snownee.kiwi.mixin.customization.Ingredient_TagValueAccess;
import snownee.kiwi.util.DeferredHolder;
import snownee.kiwi.util.codec.KCodecs;

public class DeferredIngredient
implements Supplier<Ingredient> {
    public static final Codec<Ingredient.Value> VALUE_CODEC = Codec.xor(DeferredItemValue.CODEC, Ingredient_TagValueAccess.getCODEC()).xmap(it -> (Ingredient.Value)it.map(Function.identity(), Function.identity()), it -> {
        if (it instanceof Ingredient.TagValue) {
            Ingredient.TagValue tagValue = (Ingredient.TagValue)it;
            return Either.right((Object)tagValue);
        }
        if (it instanceof DeferredItemValue) {
            DeferredItemValue itemValue = (DeferredItemValue)it;
            return Either.left((Object)itemValue);
        }
        throw new UnsupportedOperationException("This is neither an item value nor a tag value.");
    });
    public static final Codec<DeferredIngredient> CODEC = KCodecs.compactList(VALUE_CODEC).xmap(DeferredIngredient::new, it -> it.values);
    private Ingredient resolved;
    private final List<Ingredient.Value> values;

    public DeferredIngredient(List<Ingredient.Value> values) {
        this.values = values;
    }

    @Override
    public Ingredient get() {
        if (this.resolved == null) {
            this.resolved = Ingredient.fromValues(this.values.stream());
        }
        return this.resolved;
    }

    public record DeferredItemValue(DeferredHolder<Item, Item> item) implements Ingredient.Value
    {
        public static final Codec<DeferredItemValue> CODEC = DeferredHolder.codec(Registries.ITEM).xmap(DeferredItemValue::new, DeferredItemValue::item);

        public Collection<ItemStack> getItems() {
            return List.of(this.item.get().getDefaultInstance());
        }
    }
}

