/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.AccessLogRecord;

public class BackpackStorage
extends SavedData {
    private static final String SAVED_DATA_NAME = "sophisticatedbackpacks";
    private final Map<UUID, CompoundTag> backpackContents = new HashMap<UUID, CompoundTag>();
    private static final BackpackStorage clientStorageCopy = new BackpackStorage();
    private final Map<UUID, AccessLogRecord> accessLogRecords = new HashMap<UUID, AccessLogRecord>();
    private final Set<UUID> updatedBackpackSettingsFlags = new HashSet<UUID>();

    private BackpackStorage() {
    }

    public static BackpackStorage get() {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.getLevel(Level.OVERWORLD);
            DimensionDataStorage storage = overworld.getDataStorage();
            return (BackpackStorage)storage.computeIfAbsent(new SavedData.Factory(BackpackStorage::new, BackpackStorage::load), SAVED_DATA_NAME);
        }
        return clientStorageCopy;
    }

    public static BackpackStorage load(CompoundTag nbt, HolderLookup.Provider registries) {
        BackpackStorage storage = new BackpackStorage();
        BackpackStorage.readAccessLogs(nbt, storage);
        BackpackStorage.readBackpackContents(nbt, storage);
        return storage;
    }

    private static void readAccessLogs(CompoundTag nbt, BackpackStorage storage) {
        for (Tag n : nbt.getList("accessLogRecords", 10)) {
            AccessLogRecord alr = AccessLogRecord.deserializeFromNBT((CompoundTag)n);
            storage.accessLogRecords.put(alr.getBackpackUuid(), alr);
        }
    }

    private static void readBackpackContents(CompoundTag nbt, BackpackStorage storage) {
        for (Tag n : nbt.getList("backpackContents", 10)) {
            CompoundTag contents;
            CompoundTag uuidContentsPair = (CompoundTag)n;
            UUID uuid = NbtUtils.loadUUID((Tag)Objects.requireNonNull(uuidContentsPair.get("uuid")));
            if (!BackpackStorage.isPlayerBackpackOrNotEmpty(storage, uuid, contents = uuidContentsPair.getCompound("contents"))) continue;
            storage.backpackContents.put(uuid, contents);
        }
    }

    private static boolean isPlayerBackpackOrNotEmpty(BackpackStorage storage, UUID backpackUuid, CompoundTag contentsNbt) {
        CompoundTag inventoryNbt;
        if (storage.accessLogRecords.containsKey(backpackUuid)) {
            return true;
        }
        if (contentsNbt.contains("inventory") && (inventoryNbt = contentsNbt.getCompound("inventory")).contains("Items")) {
            return !inventoryNbt.getList("Items", 10).isEmpty();
        }
        return false;
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider registries) {
        CompoundTag ret = new CompoundTag();
        this.writeBackpackContents(ret);
        this.writeAccessLogs(ret);
        return ret;
    }

    private void writeBackpackContents(CompoundTag ret) {
        ListTag backpackContentsNbt = new ListTag();
        for (Map.Entry<UUID, CompoundTag> entry : this.backpackContents.entrySet()) {
            CompoundTag uuidContentsPair = new CompoundTag();
            uuidContentsPair.put("uuid", (Tag)NbtUtils.createUUID((UUID)entry.getKey()));
            uuidContentsPair.put("contents", (Tag)entry.getValue());
            backpackContentsNbt.add((Object)uuidContentsPair);
        }
        ret.put("backpackContents", (Tag)backpackContentsNbt);
    }

    private void writeAccessLogs(CompoundTag ret) {
        ListTag accessLogsNbt = new ListTag();
        for (AccessLogRecord alr : this.accessLogRecords.values()) {
            accessLogsNbt.add((Object)alr.serializeToNBT());
        }
        ret.put("accessLogRecords", (Tag)accessLogsNbt);
    }

    public CompoundTag getOrCreateBackpackContents(UUID backpackUuid) {
        return this.backpackContents.computeIfAbsent(backpackUuid, uuid -> {
            this.setDirty();
            return new CompoundTag();
        });
    }

    public void putAccessLog(AccessLogRecord alr) {
        this.accessLogRecords.put(alr.getBackpackUuid(), alr);
        this.setDirty();
    }

    public void removeBackpackContents(UUID backpackUuid) {
        this.backpackContents.remove(backpackUuid);
        this.setDirty();
    }

    public void setBackpackContents(UUID backpackUuid, CompoundTag contents) {
        if (!this.backpackContents.containsKey(backpackUuid)) {
            this.backpackContents.put(backpackUuid, contents);
            this.updatedBackpackSettingsFlags.add(backpackUuid);
        } else {
            CompoundTag currentContents = this.backpackContents.get(backpackUuid);
            for (String key : contents.getAllKeys()) {
                currentContents.put(key, contents.get(key));
                if (!key.equals("settings")) continue;
                this.updatedBackpackSettingsFlags.add(backpackUuid);
            }
            this.setDirty();
        }
    }

    public Map<UUID, AccessLogRecord> getAccessLogs() {
        return this.accessLogRecords;
    }

    public int removeNonPlayerBackpackContents(boolean onlyWithEmptyInventory) {
        AtomicInteger numberRemoved = new AtomicInteger(0);
        this.backpackContents.entrySet().removeIf(entry -> {
            if (!(this.accessLogRecords.containsKey(entry.getKey()) || onlyWithEmptyInventory && ((CompoundTag)entry.getValue()).contains("inventory"))) {
                numberRemoved.incrementAndGet();
                return true;
            }
            return false;
        });
        if (numberRemoved.get() > 0) {
            this.setDirty();
        }
        return numberRemoved.get();
    }

    public boolean removeUpdatedBackpackSettingsFlag(UUID backpackUuid) {
        return this.updatedBackpackSettingsFlags.remove(backpackUuid);
    }

    public static void onClientWorldLoad(LevelEvent.Load evt) {
        if (evt.getLevel().isClientSide()) {
            BackpackStorage.clientStorageCopy.backpackContents.clear();
            BackpackStorage.clientStorageCopy.accessLogRecords.clear();
        }
    }
}

