/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.configs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.network.SyncConfigsMessage;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class ModConfigHolder {
    private static final Map<ResourceLocation, ModConfigHolder> CONFIG_STORAGE = new ConcurrentHashMap<ResourceLocation, ModConfigHolder>();
    private final ResourceLocation configId;
    private final String fileName;
    private final Component readableName;
    private final Path filePath;
    private final ConfigType type;
    @Nullable
    private final Runnable changeCallback;

    public static void addTrackedSpec(ModConfigHolder spec) {
        ModConfigHolder old = CONFIG_STORAGE.put(spec.getId(), spec);
        if (old != null) {
            throw new IllegalStateException("Duplicate config type for with id " + String.valueOf(spec.getId()));
        }
    }

    public static Collection<ModConfigHolder> getTrackedSpecs() {
        return CONFIG_STORAGE.values();
    }

    @Nullable
    public static ModConfigHolder getConfigSpec(ResourceLocation configId) {
        return CONFIG_STORAGE.get(configId);
    }

    protected ModConfigHolder(ResourceLocation id, String fileExtension, Path configDirectory, ConfigType type, @Nullable Runnable changeCallback) {
        this.configId = id;
        this.fileName = id.getNamespace() + "-" + id.getPath() + "." + fileExtension;
        this.filePath = configDirectory.resolve(this.fileName);
        this.type = type;
        this.changeCallback = changeCallback;
        this.readableName = Component.literal((String)LangBuilder.getReadableName(id.toDebugFileName() + "_configs"));
        ModConfigHolder.addTrackedSpec(this);
    }

    public Component getReadableName() {
        return this.readableName;
    }

    protected void onRefresh() {
        if (this.changeCallback != null) {
            this.changeCallback.run();
        }
    }

    public boolean isLoaded() {
        return true;
    }

    public abstract void forceLoad();

    public ConfigType getConfigType() {
        return this.type;
    }

    public String getModId() {
        return this.configId.getNamespace();
    }

    public ResourceLocation getId() {
        return this.configId;
    }

    public boolean isSynced() {
        return this.type.isSynced();
    }

    public String getFileName() {
        return this.fileName;
    }

    public Path getFullPath() {
        return this.filePath;
    }

    public abstract void loadFromBytes(InputStream var1, boolean var2);

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Screen makeScreen(Screen parent) {
        return this.makeScreen(parent, null);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public abstract Screen makeScreen(Screen var1, @Nullable ResourceLocation var2);

    public abstract boolean hasConfigScreen();

    public void syncConfigsToPlayer(ServerPlayer player) {
        if (this.isSynced()) {
            try {
                byte[] configData = this.getConfigFileData();
                NetworkHelper.sendToClientPlayer(player, new SyncConfigsMessage(configData, this.getId()));
            }
            catch (IOException e) {
                Moonlight.LOGGER.error("Failed to sync common configs {}", (Object)this.getFileName(), (Object)e);
            }
        } else {
            throw new UnsupportedOperationException("Tried to sync a config of type " + String.valueOf((Object)this.getConfigType()));
        }
    }

    public void sendChangedConfigToServer() {
        if (this.isSynced()) {
            try {
                byte[] configData = this.getConfigFileData();
                NetworkHelper.sendToServer(new SyncConfigsMessage(configData, this.getId()));
            }
            catch (IOException e) {
                Moonlight.LOGGER.error("Failed to sync common configs {}", (Object)this.getFileName(), (Object)e);
            }
        }
    }

    protected byte[] getConfigFileData() throws IOException {
        return Files.readAllBytes(this.getFullPath());
    }

    public void sendSyncedConfigsToAllPlayers() {
        if (this.isSynced()) {
            MinecraftServer currentServer = PlatHelper.getCurrentServer();
            if (currentServer != null) {
                PlayerList playerList = currentServer.getPlayerList();
                for (ServerPlayer player : playerList.getPlayers()) {
                    this.syncConfigsToPlayer(player);
                }
            }
        } else {
            throw new UnsupportedOperationException("Tried to sync a config of type " + String.valueOf((Object)this.getConfigType()));
        }
    }

    public static class ConfigLoadingException
    extends RuntimeException {
        public ConfigLoadingException(ModConfigHolder config, Exception cause) {
            super("Failed to load config file " + config.getFileName() + " of type " + String.valueOf((Object)config.getConfigType()) + " for mod " + config.getModId() + ". Try deleting it", cause);
        }
    }
}

