/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import immersive_aircraft.Main;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_aircraft.item.upgrade.VehicleUpgrade;
import immersive_aircraft.item.upgrade.VehicleUpgradeRegistry;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class UpgradeDataLoader
extends SimpleJsonResourceReloadListener {
    public UpgradeDataLoader() {
        super(new Gson(), "aircraft_upgrades");
    }

    @NotNull
    static VehicleUpgrade getAircraftUpgrade(JsonObject jsonObject) {
        VehicleUpgrade upgrade = new VehicleUpgrade();
        for (String key : jsonObject.keySet()) {
            VehicleStat stat = VehicleStat.STATS.get(key);
            if (stat == null) continue;
            upgrade.set(stat, jsonObject.get(key).getAsFloat());
        }
        return upgrade;
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager manager, ProfilerFiller profiler) {
        VehicleUpgradeRegistry.INSTANCE.reset();
        jsonMap.forEach((identifier, jsonElement) -> {
            try {
                if (BuiltInRegistries.ITEM.containsKey(identifier)) {
                    Item item = (Item)BuiltInRegistries.ITEM.get(identifier);
                    VehicleUpgrade upgrade = UpgradeDataLoader.getAircraftUpgrade(jsonElement.getAsJsonObject());
                    VehicleUpgradeRegistry.INSTANCE.setUpgrade(item, upgrade);
                } else {
                    Main.LOGGER.error("There is no item {} to make it an upgrade!", identifier);
                }
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                Main.LOGGER.error("Parsing error on aircraft upgrade {}: {}", identifier, (Object)exception.getMessage());
            }
        });
    }
}

