/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.network.payload.s2c;

import net.conczin.immersive_paintings.ClientPaintingManager;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.network.SegmentManager;
import net.conczin.immersive_paintings.network.payload.ImmersivePayload;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record ImageResponsePayload(ResourceLocation identifier, boolean thumbnail, byte[] data, int segment, int totalSegments) implements ImmersivePayload
{
    public static final CustomPacketPayload.Type<ImageResponsePayload> TYPE = new CustomPacketPayload.Type(Main.locate("image_response"));
    public static final StreamCodec<FriendlyByteBuf, ImageResponsePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ImageResponsePayload::identifier, (StreamCodec)ByteBufCodecs.BOOL, ImageResponsePayload::thumbnail, (StreamCodec)ByteBufCodecs.BYTE_ARRAY, ImageResponsePayload::data, (StreamCodec)ByteBufCodecs.INT, ImageResponsePayload::segment, (StreamCodec)ByteBufCodecs.INT, ImageResponsePayload::totalSegments, ImageResponsePayload::new);
    private static final SegmentManager manager = new SegmentManager();

    @Override
    public void handle(Player player, ImmersivePayload.Runner runner) {
        Object key = this.identifier().toString();
        if (this.thumbnail) {
            key = (String)key + "_thumbnail";
        }
        ResourceLocation id = this.identifier();
        boolean thumbnail = this.thumbnail();
        byte[] data = this.data();
        int segment = this.segment();
        int totalSegments = this.totalSegments();
        manager.handleSegmentedPayload((String)key, data, segment, totalSegments).ifPresent(image -> runner.run(() -> {
            if (thumbnail) {
                ClientPaintingManager.registerThumbnail(id, image, false);
            } else {
                ClientPaintingManager.registerImage(id, image, false);
            }
        }));
    }

    public CustomPacketPayload.Type<ImageResponsePayload> type() {
        return TYPE;
    }
}

