/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.network.payload.c2s;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.network.SegmentManager;
import net.conczin.immersive_paintings.network.payload.ImmersivePayload;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public record ImageUploadPayload(byte[] data, int segment, int totalSegments) implements ImmersivePayload
{
    public static final CustomPacketPayload.Type<ImageUploadPayload> TYPE = new CustomPacketPayload.Type(Main.locate("image_upload"));
    public static final StreamCodec<FriendlyByteBuf, ImageUploadPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BYTE_ARRAY, ImageUploadPayload::data, (StreamCodec)ByteBufCodecs.INT, ImageUploadPayload::segment, (StreamCodec)ByteBufCodecs.INT, ImageUploadPayload::totalSegments, ImageUploadPayload::new);
    private static final SegmentManager manager = new SegmentManager();
    public static final Map<String, BufferedImage> uploaded = new HashMap<String, BufferedImage>();

    @Override
    public void handle(Player player, ImmersivePayload.Runner runner) {
        String key = player.getStringUUID();
        byte[] data = this.data();
        int segment = this.segment();
        int totalSegments = this.totalSegments();
        manager.handleSegmentedPayload(key, data, segment, totalSegments).ifPresent(image -> runner.run(() -> uploaded.put(key, (BufferedImage)image)));
    }

    public CustomPacketPayload.Type<ImageUploadPayload> type() {
        return TYPE;
    }
}

