/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.mixin.logistics.packager;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packager.PackagerBlock;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.logistics.packager.PackagerItemHandler;
import com.simibubi.create.content.logistics.packager.PackagingRequest;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.LogisticsManager;
import com.simibubi.create.content.logistics.packagerLink.PackagerLinkBlock;
import com.simibubi.create.content.logistics.packagerLink.PackagerLinkBlockEntity;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ru.zznty.create_factory_abstractions.api.generic.capability.GenericInventory;
import ru.zznty.create_factory_abstractions.api.generic.capability.GenericInventorySummaryProvider;
import ru.zznty.create_factory_abstractions.api.generic.capability.PackageBuilder;
import ru.zznty.create_factory_abstractions.api.generic.capability.PackageMeasureResult;
import ru.zznty.create_factory_abstractions.api.generic.capability.PackagerAttachedHandler;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.generic.stack.GenericStackSerializer;
import ru.zznty.create_factory_abstractions.generic.support.BigGenericStack;
import ru.zznty.create_factory_abstractions.generic.support.GenericInventorySummary;
import ru.zznty.create_factory_abstractions.generic.support.GenericOrder;
import ru.zznty.create_factory_abstractions.generic.support.GenericPackagerBlockEntity;
import ru.zznty.create_factory_abstractions.generic.support.GenericPromiseQueue;
import ru.zznty.create_factory_abstractions.generic.support.GenericRequest;
import ru.zznty.create_factory_logistics.logistics.generic.GeneticInventoryBehaviour;
import ru.zznty.create_factory_logistics.logistics.packager.GenericPackagerItemHandler;

@Mixin(value={PackagerBlockEntity.class})
public abstract class GenericPackagerBlockEntityMixin
extends SmartBlockEntity
implements GenericPackagerBlockEntity {
    @Shadow
    public InvManipulationBehaviour targetInventory;
    @Shadow
    public String signBasedAddress;
    @Shadow
    public List<BigItemStack> queuedExitingPackages;
    @Shadow
    public ItemStack heldBox;
    @Shadow
    public ItemStack previouslyUnwrapped;
    @Shadow
    public int animationTicks;
    @Shadow
    public int buttonCooldown;
    @Shadow
    public boolean animationInward;
    @Shadow
    private AdvancementBehaviour advancements;
    @Shadow
    private InventorySummary availableItems;
    @Shadow
    private VersionedInventoryTrackerBehaviour invVersionTracker;
    @Unique
    private GeneticInventoryBehaviour createFactoryLogistics$inventoryBehaviour;

    @Shadow
    public void triggerStockCheck() {
    }

    @Shadow
    private BlockPos getLinkPos() {
        return null;
    }

    @Shadow
    private boolean supportsBlockEntity(BlockEntity target) {
        return false;
    }

    public GenericPackagerBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method={"addBehaviours(Ljava/util/List;)V"}, at={@At(value="TAIL")}, remap=false)
    private void addBehaviours(List<BlockEntityBehaviour> behaviours, CallbackInfo ci) {
        this.createFactoryLogistics$inventoryBehaviour = (GeneticInventoryBehaviour)new GeneticInventoryBehaviour(this, CapManipulationBehaviourBase.InterfaceProvider.oppositeOfBlockFacing()).withFilter(this::supportsBlockEntity);
        behaviours.add((BlockEntityBehaviour)this.createFactoryLogistics$inventoryBehaviour);
    }

    @Redirect(method={"<init>(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"}, at=@At(value="NEW", target="(Lcom/simibubi/create/content/logistics/packager/PackagerBlockEntity;)Lcom/simibubi/create/content/logistics/packager/PackagerItemHandler;"))
    private PackagerItemHandler createInventory(PackagerBlockEntity blockEntity) {
        return new GenericPackagerItemHandler(blockEntity);
    }

    @Overwrite
    public InventorySummary getAvailableItems() {
        GenericInventorySummaryProvider summaryProvider;
        PackagerAttachedHandler handler;
        if (this.availableItems != null && this.invVersionTracker.stillWaiting(this.targetInventory)) {
            return this.availableItems;
        }
        GenericInventorySummary available = GenericInventorySummary.empty();
        if (this.createFactoryLogistics$inventoryBehaviour.hasInventory() && (handler = PackagerAttachedHandler.get((PackagerBlockEntity)((PackagerBlockEntity)this))) != null && (summaryProvider = ((GenericInventory)this.createFactoryLogistics$inventoryBehaviour.getInventory()).get(handler.supportedKey())) != null) {
            summaryProvider.apply(available);
            this.invVersionTracker.awaitNewVersion(this.targetInventory);
            this.createFactoryLogistics$submitNewArrivals(this.availableItems == null ? null : GenericInventorySummary.of((InventorySummary)this.availableItems), available);
        }
        this.availableItems = available.asSummary();
        return this.availableItems;
    }

    @Unique
    private void createFactoryLogistics$submitNewArrivals(GenericInventorySummary before, GenericInventorySummary after) {
        if (before == null || after.isEmpty()) {
            return;
        }
        Set<GenericPromiseQueue> promiseQueues = this.createFactoryLogistics$collectAdjacentQueues();
        if (promiseQueues.isEmpty()) {
            return;
        }
        for (GenericStack stack : after.get()) {
            before.add(stack.withAmount(-stack.amount()));
        }
        for (GenericPromiseQueue queue : promiseQueues) {
            for (GenericStack stack : before.get()) {
                if (stack.amount() >= 0) continue;
                queue.stackEnteredSystem(stack.withAmount(-stack.amount()));
            }
        }
    }

    @Unique
    private Set<GenericPromiseQueue> createFactoryLogistics$collectAdjacentQueues() {
        HashSet<GenericPromiseQueue> promiseQueues = new HashSet<GenericPromiseQueue>();
        Objects.requireNonNull(this.level);
        PackagerAttachedHandler handler = PackagerAttachedHandler.get((PackagerBlockEntity)((PackagerBlockEntity)this));
        if (handler == null) {
            return promiseQueues;
        }
        for (Direction d : Iterate.directions) {
            Object object;
            if (!this.level.isLoaded(this.worldPosition.relative(d))) continue;
            BlockState adjacentState = this.level.getBlockState(this.worldPosition.relative(d));
            if (adjacentState.is(handler.supportedGauge())) {
                if (FactoryPanelBlock.connectedDirection((BlockState)adjacentState) != d || !((object = this.level.getBlockEntity(this.worldPosition.relative(d))) instanceof FactoryPanelBlockEntity)) continue;
                FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)object;
                if (!fpbe.restocker) continue;
                object = fpbe.panels.values().iterator();
                while (object.hasNext()) {
                    FactoryPanelBehaviour behaviour = (FactoryPanelBehaviour)object.next();
                    if (!behaviour.isActive()) continue;
                    promiseQueues.add((GenericPromiseQueue)behaviour.restockerPromises);
                }
            }
            if (!AllBlocks.STOCK_LINK.has(adjacentState) || PackagerLinkBlock.getConnectedDirection((BlockState)adjacentState) != d || !((object = this.level.getBlockEntity(this.worldPosition.relative(d))) instanceof PackagerLinkBlockEntity)) continue;
            PackagerLinkBlockEntity plbe = (PackagerLinkBlockEntity)object;
            UUID freqId = plbe.behaviour.freqId;
            if (!Create.LOGISTICS.hasQueuedPromises(freqId)) continue;
            promiseQueues.add((GenericPromiseQueue)Create.LOGISTICS.getQueuedPromises(freqId));
        }
        return promiseQueues;
    }

    @Overwrite
    public boolean unwrapBox(ItemStack box, boolean simulate) {
        if (this.animationTicks > 0) {
            return false;
        }
        Objects.requireNonNull(this.level);
        GenericOrder orderContext = GenericOrder.of((HolderLookup.Provider)this.level.registryAccess(), (ItemStack)box);
        Direction facing = this.getBlockState().getOptionalValue((Property)PackagerBlock.FACING).orElse(Direction.UP);
        BlockPos target = this.worldPosition.relative(facing.getOpposite());
        BlockState targetState = this.level.getBlockState(target);
        ItemStack originalBox = box.copy();
        boolean unpacked = Optional.ofNullable(PackagerAttachedHandler.get((PackagerBlockEntity)((PackagerBlockEntity)this))).map(handler -> handler.unwrap(this.level, target, targetState, facing, orderContext == null ? null : orderContext.asCrafting(), box, simulate)).orElse(false);
        if (unpacked && !simulate) {
            this.previouslyUnwrapped = originalBox;
            this.animationInward = true;
            this.animationTicks = 20;
            this.notifyUpdate();
        }
        return unpacked;
    }

    @Overwrite
    public void attemptToSend(List<PackagingRequest> queuedRequests) {
        if (!(queuedRequests != null || this.heldBox.isEmpty() && this.animationTicks == 0 && this.buttonCooldown <= 0)) {
            return;
        }
        if (queuedRequests == null) {
            this.attemptToSendGeneric(null);
            return;
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void attemptToSendGeneric(Collection<GenericRequest> queuedRequests) {
        BlockEntity blockEntity;
        Pair<ItemStack, PackageBuilder> extracted = this.createFactoryLogistics$extractBox(queuedRequests);
        if (((ItemStack)extracted.getFirst()).isEmpty()) {
            return;
        }
        BlockPos linkPos = this.getLinkPos();
        if (linkPos != null && (blockEntity = this.level.getBlockEntity(linkPos)) instanceof PackagerLinkBlockEntity) {
            PackagerLinkBlockEntity plbe = (PackagerLinkBlockEntity)blockEntity;
            this.createFactoryLogistics$deductFromAccurateSummary(plbe.behaviour, (PackageBuilder)extracted.getSecond());
        }
        if (!this.heldBox.isEmpty() || this.animationTicks != 0) {
            this.queuedExitingPackages.add(new BigItemStack((ItemStack)extracted.getFirst()));
            return;
        }
        this.heldBox = (ItemStack)extracted.getFirst();
        this.animationInward = false;
        this.animationTicks = 20;
        this.advancements.awardPlayer(AllAdvancements.PACKAGER);
        this.triggerStockCheck();
        this.notifyUpdate();
    }

    @Unique
    public void createFactoryLogistics$deductFromAccurateSummary(LogisticallyLinkedBehaviour behaviour, PackageBuilder content) {
        InventorySummary accurateSummary = (InventorySummary)LogisticsManager.ACCURATE_SUMMARIES.getIfPresent((Object)behaviour.freqId);
        if (accurateSummary == null) {
            return;
        }
        GenericInventorySummary summary = GenericInventorySummary.of((InventorySummary)accurateSummary);
        for (GenericStack stack : content.content()) {
            summary.add(stack.withAmount(-Math.min(summary.getCountOf(stack.key()), stack.amount())));
        }
    }

    @Unique
    public Pair<ItemStack, PackageBuilder> createFactoryLogistics$extractBox(Collection<GenericRequest> queuedRequests) {
        ItemStack box;
        boolean requestQueue = queuedRequests != null;
        int linkIndexInOrder = 0;
        boolean finalLinkInOrder = false;
        int packageIndexAtLink = 0;
        boolean finalPackageAtLink = false;
        GenericOrder orderContext = null;
        int fixedOrderId = 0;
        String fixedAddress = null;
        PackagerAttachedHandler target = PackagerAttachedHandler.get((PackagerBlockEntity)((PackagerBlockEntity)this));
        if (target == null) {
            return Pair.of((Object)ItemStack.EMPTY, null);
        }
        boolean anyItemPresent = false;
        PackageBuilder extractedPackage = target.newPackage();
        GenericRequest nextRequest = null;
        Iterator<GenericRequest> requestIterator = null;
        if (requestQueue && !queuedRequests.isEmpty()) {
            requestIterator = queuedRequests.iterator();
            nextRequest = requestIterator.next();
            fixedAddress = nextRequest.address();
            fixedOrderId = nextRequest.orderId();
            linkIndexInOrder = nextRequest.linkIndex();
            finalLinkInOrder = nextRequest.finalLink().booleanValue();
            packageIndexAtLink = nextRequest.packageCounter().getAndIncrement();
            orderContext = nextRequest.context();
        }
        block0: for (int i = 0; i < extractedPackage.slotCount(); ++i) {
            boolean continuePacking = true;
            block1: while (continuePacking) {
                continuePacking = false;
                for (int slot = 0; slot < target.slotCount(); ++slot) {
                    int transferred;
                    int leftovers;
                    boolean bulky;
                    int initialAmount = requestQueue ? Math.min(extractedPackage.maxPerSlot(), nextRequest.getCount()) : extractedPackage.maxPerSlot();
                    GenericStack extracted = target.extract(slot, initialAmount, true);
                    if (extracted.isEmpty() || requestQueue && !nextRequest.stack().canStack(extracted)) continue;
                    boolean bl = bulky = extractedPackage.measure(extracted.key()) == PackageMeasureResult.BULKY;
                    if (bulky && anyItemPresent || (leftovers = extractedPackage.add(extracted)) < 0 || target.extract(slot, transferred = extracted.amount() - leftovers, false).isEmpty()) continue;
                    anyItemPresent = true;
                    if (!requestQueue) {
                        if (!bulky) continue;
                        break block0;
                    }
                    nextRequest.subtract(transferred);
                    if (!nextRequest.isEmpty()) {
                        if (!bulky) continue;
                        break block0;
                    }
                    finalPackageAtLink = true;
                    requestIterator.remove();
                    if (!requestIterator.hasNext()) break block0;
                    int previousCount = nextRequest.packageCounter().intValue();
                    nextRequest = requestIterator.next();
                    if (!fixedAddress.equals(nextRequest.address()) || fixedOrderId != nextRequest.orderId()) break block0;
                    nextRequest.packageCounter().setValue(previousCount);
                    finalPackageAtLink = false;
                    continuePacking = true;
                    if (nextRequest.context() != null) {
                        orderContext = nextRequest.context();
                    }
                    if (!bulky) continue block1;
                    break block0;
                }
            }
        }
        if ((box = extractedPackage.build()).isEmpty()) {
            return Pair.of((Object)ItemStack.EMPTY, null);
        }
        PackageItem.clearAddress((ItemStack)box);
        if (fixedAddress != null) {
            PackageItem.addAddress((ItemStack)box, (String)fixedAddress);
        }
        if (requestQueue) {
            GenericOrder.set((HolderLookup.Provider)this.level.registryAccess(), (ItemStack)box, (int)fixedOrderId, (int)linkIndexInOrder, (boolean)finalLinkInOrder, (int)packageIndexAtLink, (boolean)finalPackageAtLink, orderContext);
        }
        if (!requestQueue && !this.signBasedAddress.isBlank()) {
            PackageItem.addAddress((ItemStack)box, (String)this.signBasedAddress);
        }
        return Pair.of((Object)box, (Object)extractedPackage);
    }

    @WrapOperation(method={"read(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;Z)V"}, at={@At(value="INVOKE", target="Lnet/createmod/catnip/nbt/NBTHelper;readCompoundList(Lnet/minecraft/nbt/ListTag;Ljava/util/function/Function;)Ljava/util/List;")})
    private List<BigItemStack> readQueuedExitingPackages(ListTag listNBT, Function<CompoundTag, BigItemStack> deserializer, Operation<List<BigItemStack>> original) {
        return NBTHelper.readCompoundList((ListTag)listNBT, t -> BigGenericStack.of((GenericStack)GenericStackSerializer.read((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)t)).asStack());
    }

    @WrapOperation(method={"write(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;Z)V"}, at={@At(value="INVOKE", target="Lnet/createmod/catnip/nbt/NBTHelper;writeCompoundList(Ljava/lang/Iterable;Ljava/util/function/Function;)Lnet/minecraft/nbt/ListTag;")})
    private ListTag writeQueuedExitingPackages(Iterable<BigItemStack> list, Function<BigItemStack, CompoundTag> serializer, Operation<ListTag> original) {
        return NBTHelper.writeCompoundList(list, t -> {
            CompoundTag tag = new CompoundTag();
            GenericStackSerializer.write((HolderLookup.Provider)this.level.registryAccess(), (GenericStack)BigGenericStack.of((BigItemStack)t).get(), (CompoundTag)tag);
            return tag;
        });
    }

    @WrapOperation(method={"read(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;Z)V"}, at={@At(value="INVOKE", target="Lnet/createmod/catnip/codecs/CatnipCodecUtils;decode(Lcom/mojang/serialization/Codec;Lnet/minecraft/core/HolderLookup$Provider;Lnet/minecraft/nbt/Tag;)Ljava/util/Optional;")})
    private Optional<InventorySummary> readLastSummary(Codec<InventorySummary> codec, HolderLookup.Provider registries, Tag tag, Operation<Optional<InventorySummary>> original) {
        GenericInventorySummary summary = GenericInventorySummary.empty();
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            NBTHelper.iterateCompoundList((ListTag)listTag, t -> summary.add(GenericStackSerializer.read((HolderLookup.Provider)registries, (CompoundTag)t)));
        }
        return Optional.of(summary.asSummary());
    }

    @Redirect(method={"write(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;Z)V"}, at=@At(value="INVOKE", target="Lnet/createmod/catnip/codecs/CatnipCodecUtils;encode(Lcom/mojang/serialization/Codec;Lnet/minecraft/core/HolderLookup$Provider;Ljava/lang/Object;)Ljava/util/Optional;"))
    private Optional<Tag> writeLastSummary(Codec<InventorySummary> codec, HolderLookup.Provider registries, Object t) {
        GenericInventorySummary summary = GenericInventorySummary.of((InventorySummary)((InventorySummary)t));
        return Optional.of(NBTHelper.writeCompoundList((Iterable)summary.get(), stack -> {
            CompoundTag tag = new CompoundTag();
            GenericStackSerializer.write((HolderLookup.Provider)registries, (GenericStack)stack, (CompoundTag)tag);
            return tag;
        }));
    }

    @WrapMethod(method={"isSameInventoryFallback(Lnet/neoforged/neoforge/items/IItemHandler;Lnet/neoforged/neoforge/items/IItemHandler;)Z"})
    private static boolean isSameInventoryNullCheck(IItemHandler first, IItemHandler second, Operation<Boolean> original) {
        if (first == null || second == null) {
            return false;
        }
        return (Boolean)original.call(new Object[]{first, second});
    }
}

