/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.panel;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockItem;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.simibubi.create.foundation.utility.CreateLang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import ru.zznty.create_factory_logistics.FactoryBlockEntities;
import ru.zznty.create_factory_logistics.FactoryBlocks;
import ru.zznty.create_factory_logistics.logistics.panel.FactoryFluidPanelBlockEntity;

public class FactoryFluidPanelBlock
extends FactoryPanelBlock {
    public FactoryFluidPanelBlock(BlockBehaviour.Properties p_53182_) {
        super(p_53182_);
    }

    public Class getBlockEntityClass() {
        return FactoryFluidPanelBlockEntity.class;
    }

    public BlockEntityType<? extends FactoryPanelBlockEntity> getBlockEntityType() {
        return (BlockEntityType)FactoryBlockEntities.FACTORY_FLUID_PANEL.get();
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (!FactoryBlocks.FACTORY_FLUID_GAUGE.isIn(stack)) {
            return ItemInteractionResult.SUCCESS;
        }
        Vec3 location = hitResult.getLocation();
        if (location == null) {
            return ItemInteractionResult.SUCCESS;
        }
        if (!FactoryPanelBlockItem.isTuned((ItemStack)stack)) {
            AllSoundEvents.DENY.playOnServer(level, (Vec3i)pos);
            player.displayClientMessage((Component)CreateLang.translate((String)"factory_panel.tune_before_placing", (Object[])new Object[0]).component(), true);
            return ItemInteractionResult.FAIL;
        }
        FactoryPanelBlock.PanelSlot newSlot = FactoryFluidPanelBlock.getTargetedSlot((BlockPos)pos, (BlockState)state, (Vec3)location);
        this.withBlockEntityDo((BlockGetter)level, pos, fpbe -> {
            if (!fpbe.addPanel(newSlot, LogisticallyLinkedBlockItem.networkFromStack((ItemStack)FactoryPanelBlockItem.fixCtrlCopiedStack((ItemStack)stack)))) {
                return;
            }
            player.displayClientMessage((Component)CreateLang.translateDirect((String)"logistically_linked.connected", (Object[])new Object[0]), true);
            level.playSound(null, pos, this.soundType.getPlaceSound(), SoundSource.BLOCKS);
            if (player.isCreative()) {
                return;
            }
            stack.shrink(1);
            if (stack.isEmpty()) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            }
        });
        return ItemInteractionResult.SUCCESS;
    }

    public boolean canBeReplaced(BlockState pState, BlockPlaceContext pUseContext) {
        if (pUseContext.isSecondaryUseActive()) {
            return false;
        }
        if (!FactoryBlocks.FACTORY_FLUID_GAUGE.isIn(pUseContext.getItemInHand())) {
            return false;
        }
        Vec3 location = pUseContext.getClickLocation();
        if (location == null) {
            return false;
        }
        BlockPos pos = pUseContext.getClickedPos();
        FactoryPanelBlock.PanelSlot slot = FactoryFluidPanelBlock.getTargetedSlot((BlockPos)pos, (BlockState)pState, (Vec3)location);
        FactoryPanelBlockEntity blockEntity = (FactoryPanelBlockEntity)this.getBlockEntity((BlockGetter)pUseContext.getLevel(), pos);
        if (blockEntity == null) {
            return false;
        }
        return !((FactoryPanelBehaviour)blockEntity.panels.get(slot)).isActive();
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        FactoryPanelBlock.PanelSlot slot = FactoryFluidPanelBlock.getTargetedSlot((BlockPos)pos, (BlockState)state, (Vec3)context.getClickLocation());
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        return this.onBlockEntityUse((BlockGetter)world, pos, be -> {
            FactoryPanelBehaviour behaviour = (FactoryPanelBehaviour)be.panels.get(slot);
            if (behaviour == null || !behaviour.isActive()) {
                return InteractionResult.SUCCESS;
            }
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, world.getBlockState(pos), player);
            NeoForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return InteractionResult.SUCCESS;
            }
            if (!be.removePanel(slot)) {
                return InteractionResult.SUCCESS;
            }
            if (!player.isCreative()) {
                player.getInventory().placeItemBackInInventory(FactoryBlocks.FACTORY_FLUID_GAUGE.asStack());
            }
            IWrenchable.playRemoveSound((Level)world, (BlockPos)pos);
            if (be.activePanels() == 0) {
                world.destroyBlock(pos, false);
            }
            return InteractionResult.SUCCESS;
        });
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (this.tryDestroySubPanelFirst(state, level, pos, player)) {
            return false;
        }
        this.playerWillDestroy(level, pos, state, player);
        return level.setBlock(pos, fluid.createLegacyBlock(), level.isClientSide ? 11 : 3);
    }

    private boolean tryDestroySubPanelFirst(BlockState state, Level level, BlockPos pos, Player player) {
        double range = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue() + 1.0;
        HitResult hitResult = player.pick(range, 1.0f, false);
        Vec3 location = hitResult.getLocation();
        FactoryPanelBlock.PanelSlot destroyedSlot = FactoryFluidPanelBlock.getTargetedSlot((BlockPos)pos, (BlockState)state, (Vec3)location);
        return InteractionResult.SUCCESS == this.onBlockEntityUse((BlockGetter)level, pos, fpbe -> {
            if (fpbe.activePanels() < 2) {
                return InteractionResult.FAIL;
            }
            if (!fpbe.removePanel(destroyedSlot)) {
                return InteractionResult.FAIL;
            }
            if (!player.isCreative()) {
                FactoryFluidPanelBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)FactoryBlocks.FACTORY_FLUID_GAUGE.asStack());
            }
            return InteractionResult.SUCCESS;
        });
    }
}

