/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.data;

import com.mojang.datafixers.util.Pair;
import gg.moonflower.etched.common.component.DiscAppearanceComponent;
import gg.moonflower.etched.core.Etched;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import gg.moonflower.etched.core.registry.EtchedItems;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.loaders.SeparateTransformsModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class EtchedItemModelProvider
extends ItemModelProvider {
    public EtchedItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "etched", existingFileHelper);
    }

    public ItemModelBuilder basicItem(ItemLike item) {
        return this.basicItem(item.asItem());
    }

    private ItemModelBuilder generated(String name) {
        return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"));
    }

    private ItemModelBuilder generated(ItemLike item) {
        return this.generated(Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item.asItem())).toString());
    }

    public ItemModelBuilder getBuilder(ItemLike item) {
        return (ItemModelBuilder)this.getBuilder(Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item.asItem())).toString());
    }

    protected void registerModels() {
        ((ItemModelBuilder)this.generated((ItemLike)EtchedItems.MUSIC_LABEL).texture("layer0", Etched.etchedPath("item/music_label_top"))).texture("layer1", Etched.etchedPath("item/music_label_bottom"));
        this.basicItem((ItemLike)EtchedItems.BLANK_MUSIC_DISC);
        ItemModelBuilder etchedMusicDisc = this.getBuilder((ItemLike)EtchedItems.ETCHED_MUSIC_DISC);
        for (DiscAppearanceComponent.LabelPattern value : DiscAppearanceComponent.LabelPattern.values()) {
            Pair<ResourceLocation, ResourceLocation> textures = value.getTextures();
            ItemModelBuilder builder = this.generated("item/etched_music_disc/" + value.name().toLowerCase(Locale.ROOT));
            builder.texture("layer0", etchedMusicDisc.getLocation());
            builder.texture("layer1", ((ResourceLocation)textures.getFirst()).withPath(p -> p.substring(9, p.length() - 4)));
            if (value.isComplex()) {
                builder.texture("layer2", ((ResourceLocation)textures.getSecond()).withPath(p -> p.substring(9, p.length() - 4)));
            }
            if (value.ordinal() == 0) {
                etchedMusicDisc.parent((ModelFile)builder);
            }
            etchedMusicDisc.override().predicate(Etched.etchedPath("pattern"), (float)value.ordinal()).model((ModelFile)builder);
        }
        this.generated("boombox_gui").texture("layer0", Etched.etchedPath("item/boombox"));
        this.basicItem((ItemLike)EtchedItems.JUKEBOX_MINECART);
        ((ItemModelBuilder)this.getBuilder((ItemLike)EtchedItems.ALBUM_COVER).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).guiLight(BlockModel.GuiLight.FRONT);
        this.generated("item/etched_album_cover/blank").texture("layer0", Etched.etchedPath("item/blank_album_cover"));
        this.generated("item/etched_album_cover/default").texture("layer0", Etched.etchedPath("item/default_album_cover"));
        for (Map.Entry entry : BuiltInRegistries.ITEM.entrySet()) {
            ResourceLocation name = ((ResourceKey)entry.getKey()).location();
            Item item = (Item)entry.getValue();
            if (!item.components().has(DataComponents.JUKEBOX_PLAYABLE)) continue;
            this.generated(name.withPath(p -> "item/etched_album_cover/" + p).toString()).texture("layer0", Etched.etchedPath("item/vanilla_album_cover"));
        }
        ItemModelBuilder boomboxInventory = (ItemModelBuilder)new ItemModelBuilder(Etched.etchedPath("boombox_gui"), this.existingFileHelper).parent((ModelFile)new ModelFile.ExistingModelFile(Etched.etchedPath("item/boombox_gui"), this.existingFileHelper));
        ItemModelBuilder boomboxPlaying = (ItemModelBuilder)((SeparateTransformsModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("item/boombox_playing")).parent((ModelFile)new ModelFile.ExistingModelFile(Etched.etchedPath("item/boombox_in_hand_playing"), this.existingFileHelper))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)new ItemModelBuilder(Etched.etchedPath("boombox_in_hand_playing"), this.existingFileHelper).parent((ModelFile)new ModelFile.ExistingModelFile(Etched.etchedPath("item/boombox_in_hand_playing"), this.existingFileHelper)))).perspective(ItemDisplayContext.GUI, (ModelBuilder)boomboxInventory).perspective(ItemDisplayContext.GROUND, (ModelBuilder)boomboxInventory).perspective(ItemDisplayContext.FIXED, (ModelBuilder)boomboxInventory).end();
        ((ItemModelBuilder)((SeparateTransformsModelBuilder)((ItemModelBuilder)this.getBuilder((ItemLike)EtchedItems.BOOMBOX).parent((ModelFile)new ModelFile.ExistingModelFile(Etched.etchedPath("item/boombox_in_hand"), this.existingFileHelper))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)new ItemModelBuilder(Etched.etchedPath("boombox_in_hand"), this.existingFileHelper).parent((ModelFile)new ModelFile.ExistingModelFile(Etched.etchedPath("item/boombox_in_hand"), this.existingFileHelper)))).perspective(ItemDisplayContext.GUI, (ModelBuilder)boomboxInventory).perspective(ItemDisplayContext.GROUND, (ModelBuilder)boomboxInventory).perspective(ItemDisplayContext.FIXED, (ModelBuilder)boomboxInventory).end()).override().model((ModelFile)boomboxPlaying).predicate(Etched.etchedPath("playing"), 1.0f);
        this.simpleBlockItem((Block)EtchedBlocks.ETCHING_TABLE.get());
        this.simpleBlockItem((Block)EtchedBlocks.ALBUM_JUKEBOX.get());
        this.basicItem((ItemLike)EtchedBlocks.RADIO);
        this.basicItem((ItemLike)EtchedBlocks.PORTAL_RADIO_ITEM);
    }
}

