/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.network;

import gg.moonflower.etched.common.network.play.ClientboundInvalidEtchUrlPacket;
import gg.moonflower.etched.common.network.play.ClientboundPlayBlockMusicPacket;
import gg.moonflower.etched.common.network.play.ClientboundPlayEntityMusicPacket;
import gg.moonflower.etched.common.network.play.ServerboundEditMusicLabelPacket;
import gg.moonflower.etched.common.network.play.SetAlbumJukeboxTrackPacket;
import gg.moonflower.etched.common.network.play.SetUrlPacket;
import gg.moonflower.etched.common.network.play.handler.EtchedClientPlayPacketHandler;
import gg.moonflower.etched.common.network.play.handler.EtchedServerPlayPacketHandler;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="etched", bus=EventBusSubscriber.Bus.MOD)
public class EtchedMessages {
    @SubscribeEvent
    public static void init(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("4");
        registrar.playToClient(ClientboundInvalidEtchUrlPacket.TYPE, ClientboundInvalidEtchUrlPacket.CODEC, EtchedMessages.clientHandler(() -> EtchedClientPlayPacketHandler::handleSetInvalidEtch));
        registrar.playToClient(ClientboundPlayBlockMusicPacket.TYPE, ClientboundPlayBlockMusicPacket.CODEC, EtchedMessages.clientHandler(() -> EtchedClientPlayPacketHandler::handlePlayBlockMusicPacket));
        registrar.playToClient(ClientboundPlayEntityMusicPacket.TYPE, ClientboundPlayEntityMusicPacket.CODEC, EtchedMessages.clientHandler(() -> EtchedClientPlayPacketHandler::handlePlayEntityMusicPacket));
        registrar.playToServer(ServerboundEditMusicLabelPacket.TYPE, ServerboundEditMusicLabelPacket.CODEC, EtchedServerPlayPacketHandler::handleEditMusicLabel);
        EtchedMessages.registerBidirectional(registrar, SetAlbumJukeboxTrackPacket.TYPE, SetAlbumJukeboxTrackPacket.CODEC, EtchedMessages.clientHandler(() -> EtchedClientPlayPacketHandler::handleSetAlbumJukeboxTrack), EtchedServerPlayPacketHandler::handleSetAlbumJukeboxTrack);
        EtchedMessages.registerBidirectional(registrar, SetUrlPacket.TYPE, SetUrlPacket.CODEC, EtchedMessages.clientHandler(() -> EtchedClientPlayPacketHandler::handleSetUrl), EtchedServerPlayPacketHandler::handleSetUrl);
    }

    private static <T extends CustomPacketPayload> IPayloadHandler<T> clientHandler(Supplier<IPayloadHandler<T>> handler) {
        return FMLLoader.getDist() == Dist.CLIENT ? handler.get() : (payload, context) -> {};
    }

    private static <T extends CustomPacketPayload> void registerBidirectional(PayloadRegistrar registrar, CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> reader, IPayloadHandler<T> clientHandler, IPayloadHandler<T> serverHandler) {
        registrar.playBidirectional(type, reader, (pkt, ctx) -> {
            if (ctx.flow().isClientbound()) {
                clientHandler.handle(pkt, ctx);
            } else {
                serverHandler.handle(pkt, ctx);
            }
        });
    }
}

