/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.sound.download;

import gg.moonflower.etched.api.record.AlbumCover;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.download.SoundDownloadSource;
import gg.moonflower.etched.api.sound.source.AudioSource;
import gg.moonflower.etched.api.sound.source.RawAudioSource;
import gg.moonflower.etched.api.sound.source.StreamingAudioSource;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import gg.moonflower.etched.client.AlbumCoverCache;
import java.io.IOException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class SoundSourceManager {
    private static final Set<SoundDownloadSource> SOURCES = new HashSet<SoundDownloadSource>();
    private static final Logger LOGGER = LogManager.getLogger();

    private SoundSourceManager() {
    }

    public static synchronized void registerSource(SoundDownloadSource source) {
        SOURCES.add(source);
    }

    public static CompletableFuture<AudioSource> getAudioSource(String url, @Nullable DownloadProgressListener listener, Proxy proxy, AudioSource.AudioFileType type) {
        Optional<SoundDownloadSource> sourceOptional = SOURCES.stream().filter(s -> s.isValidUrl(url)).findFirst();
        if (sourceOptional.isEmpty()) {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    return new RawAudioSource(new URI(url).toURL(), listener, false, type);
                }
                catch (Throwable t) {
                    throw new CompletionException("Failed to download audio: " + url, t);
                }
            }, Util.nonCriticalIoPool());
        }
        SoundDownloadSource source = sourceOptional.get();
        return CompletableFuture.supplyAsync(() -> {
            try {
                Collection<URL> urls = source.resolveUrl(url, listener, proxy);
                if (urls.isEmpty()) {
                    throw new IOException("No audio data was found at the source!");
                }
                if (urls.size() == 1) {
                    return new RawAudioSource(urls.iterator().next(), listener, source.isTemporary(url), type);
                }
                return new StreamingAudioSource((URL[])urls.toArray(URL[]::new), listener, source.isTemporary(url), type);
            }
            catch (Throwable t) {
                throw new CompletionException("Failed to connect to " + source.getApiName() + " API", t);
            }
        }, Util.nonCriticalIoPool());
    }

    public static CompletableFuture<TrackData[]> resolveTracks(String url, @Nullable DownloadProgressListener listener, Proxy proxy) {
        Optional<SoundDownloadSource> sourceOptional = SOURCES.stream().filter(s -> s.isValidUrl(url)).findFirst();
        if (sourceOptional.isEmpty()) {
            return CompletableFuture.failedFuture(new IOException("Unknown source for: " + url));
        }
        SoundDownloadSource source = sourceOptional.get();
        return CompletableFuture.supplyAsync(() -> {
            try {
                return (TrackData[])source.resolveTracks(url, listener, proxy).toArray(TrackData[]::new);
            }
            catch (Throwable t) {
                throw new CompletionException("Failed to connect to " + source.getApiName() + " API", t);
            }
        }, Util.nonCriticalIoPool());
    }

    public static CompletableFuture<AlbumCover> resolveAlbumCover(String url, @Nullable DownloadProgressListener listener, Proxy proxy, ResourceManager resourceManager) {
        Optional<SoundDownloadSource> sourceOptional = SOURCES.stream().filter(s -> s.isValidUrl(url)).findFirst();
        if (sourceOptional.isEmpty()) {
            return CompletableFuture.completedFuture(AlbumCover.EMPTY);
        }
        SoundDownloadSource source = sourceOptional.get();
        return CompletableFuture.supplyAsync(() -> {
            try {
                Optional<String> coverUrl = source.resolveAlbumCover(url, listener, proxy, resourceManager);
                return coverUrl.map(AlbumCoverCache::requestResource).orElseGet(() -> CompletableFuture.completedFuture(AlbumCover.EMPTY));
            }
            catch (Throwable t) {
                LOGGER.error("Failed to connect to {} API", (Object)source.getApiName(), (Object)t);
                return CompletableFuture.completedFuture(AlbumCover.EMPTY);
            }
        }, Util.nonCriticalIoPool()).thenCompose(future -> future);
    }

    public static Optional<Component> getBrandText(String url) {
        return SOURCES.stream().filter(source -> source.isValidUrl(url)).findFirst().flatMap(s -> s.getBrandText(url));
    }

    public static boolean isValidUrl(String url) {
        return SOURCES.stream().anyMatch(s -> s.isValidUrl(url));
    }
}

